/*
///////////////////////////////////////////////////////////////////////////////////////////////////
//shnQ@hhbvO
//	FileName	IIC.c
//	Version		1.00
//	MCU		H8/3694
//	Work		
//-------------------------------------------------------------------------------------------------
//
//	2007/04/19	Ver1.00
//-------------------------------------------------------------------------------------------------
*/

/*

̃\tgEFA̓t[EFAłB

̃\tgEFAɊւ鎿ɂ܂ẮA
T|[g̑ΏۊOƂȂ܂B

쌠͍쐬ł()kldqL̂Ƃ܂B

̃\tgEFAgpƂɂSĂ̑QɂāA
쐬͈؂̐ӔC𕉂Ȃ̂Ƃ܂B

̃\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ
֎~܂BGȂǂ֏ЉE^̏ꍇ͘A肢v
܂B

@Copyright (C) Hokuto denshi Co,Ltd. 2007

*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//CN[ht@C錾
*/
/* }CRCu */
#include <machine.h>

/* WbCu */

/* IWi */
#include "3694S.h"
#include "Main.h"
#include "IIC.h"


/*
/////////////////////////////////////////////////////////////////////////////////////////
//萔錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//^錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//ϐ錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//}N錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//֐vg^Cv錾
*/
void Init_IIC ( void );

unsigned char byte_read( unsigned int addr );
void byte_write( unsigned int addr, unsigned char data );
unsigned char iic_write( unsigned char data );
void wait( int msec );


/*
/////////////////////////////////////////////////////////////////////////////////////////
//֐vg^Cv錾
*/


/*
///////////////////////////////////////////////////////////////////////////////
//Init_IIC
//Ehhb
//-----------------------------------------------------------------------------
//return
//-----------------------------------------------------------------------------
//param
//-----------------------------------------------------------------------------
*/
void Init_IIC ( void )
{
	/* hhbp|[g */
	IIC2.ICCR1.BIT.CKS = 1;
	IIC2.ICCR1.BIT.ICE = 1;
	IIC2.ICCR2.BYTE = 0x7d;
	IIC2.ICMR.BYTE = 0x30;
	
	
	/* rW[`FbN */
	while ( IIC2.ICCR2.BIT.BBSY != 0 );
	
	
}




void byte_write( unsigned int addr, unsigned char data )
{
	unsigned char code;
	
//	Write_SCI ( strlen ( "byte_write start\r\n" ), "byte_write start\r\n" );
	IIC2.ICCR1.BYTE = 0x84;		/* 10000000 oXC^[tF[X2Cl[u*/
	IIC2.ICCR2.BYTE = 0x7d;		/* l̂܂ */
	IIC2.ICMR.BYTE = 0x30;		/* 00110000 */
	while( ( IIC2.ICCR2.BYTE & 0x80 ) != 0 ){			/* oXrW[tO */
	}						/* oXJ܂ő҂ */
	IIC2.ICCR1.BYTE = IIC2.ICCR1.BYTE | 0x30;				/* }X^M[hɐݒ */
	IIC2.ICCR2.BYTE = (( IIC2.ICCR2.BYTE | 0x80 ) & ~0x40 );		/* X^[gRfBV BBSY=1,SCP=0 */
/*	iic_write( 0xa0 );*/				/* foCXAhXAM */
	iic_write( 0xa0 + ( ( addr & 0x0700 ) >> 7 ) );	/* foCXAhXAM */
/*	iic_write( ( addr & 0xff00 ) >> 8 );*/		/* ݃AhX */
	iic_write( ( addr & 0x00ff ) );			/* ݃AhX */
	iic_write( data );				/* ݃f[^ */
	IIC2.ICCR2.BYTE = IIC2.ICCR2.BYTE & ~0xc0;			/* XgbvRfBV BBSY=0,SCP=0 */
	wait( 40 );					/* ݑ҂ */
//	Write_SCI ( strlen ( "byte_write end\r\n" ), "byte_write end\r\n" );
}
unsigned char byte_read( unsigned int addr )
{
	unsigned char code;
	
	IIC2.ICCR1.BYTE = 0x84;		/* 10000000 oXC^[tF[XQCl[u*/
	IIC2.ICCR2.BYTE = 0x7d;		/* l̂܂ */
	IIC2.ICMR.BYTE = 0x30;		/* 00110000 */
	while( ( IIC2.ICCR2.BYTE & 0x80 ) != 0 ){			/* oXrW[tO */
	}						/* oXJ܂ő҂ */
	IIC2.ICCR1.BYTE = IIC2.ICCR1.BYTE | 0x30;				/* }X^M[hɐݒ */
	IIC2.ICCR2.BYTE = ( IIC2.ICCR2.BYTE | 0x80 ) & ~0x40;		/* X^[gRfBV BBSY=1,SCP=0*/
/*	iic_write( 0xa0 );*/				/* foCXAhXAM */
	iic_write( 0xa0 + ( ( addr & 0x0700 ) >> 7 ) );	/* foCXAhXAM */
/*	iic_write( ( addr & 0xff00 ) >> 8 );*/		/* ݃AhX */
	iic_write( ( addr & 0x00ff ) );			/* ݃AhX */
	IIC2.ICCR2.BYTE = ( IIC2.ICCR2.BYTE | 0x80 ) & ~0x40;		/* X^[gRfBV BBSY=1,SCP=0*/

	iic_write( 0xa1 );				/* foCXAhXAMA݃AhX */
	IIC2.ICCR1.BYTE = IIC2.ICCR1.BYTE & ~0x10;			/* TRS=0 */
	IIC2.ICIER.BYTE = IIC2.ICIER.BYTE & ~0x02;				/*MtONA*/
	IIC2.ICIER.BYTE = IIC2.ICIER.BYTE | 0x01;				/* ACKB=1iANmbWMj */
	code = IIC2.ICDRR;					/* _~[M */
	while( ( IIC2.ICSR.BYTE & 0x20 ) == 0 ){		/* RDRF MI܂ő҂ */
	}
	code = IIC2.ICDRR;					/* f[^M */
	while( ( IIC2.ICSR.BYTE & 0x20 ) == 0 ){		/* MI܂ő҂ */
	}
	IIC2.ICCR2.BYTE = IIC2.ICCR2.BYTE & ~0xc0;			/* XgbvRfBV BBSY=0,SCP=0 */
	return( code );
}
unsigned char iic_write( unsigned char data )
{
	while( ( IIC2.ICSR.BYTE & 0x80 ) == 0 ){			/* TDRE=1 Mf[^GveB܂ő҂ */
	}
	IIC2.ICDRT = data;					/* f[^ */
	while( ( IIC2.ICSR.BYTE & 0x40 ) == 0 ){			/* TEND=1 M܂ő҂ */
	}
	if( ( IIC2.ICIER.BYTE & 0x02 ) != 0 ){			/* ACKAĂȂ */
		IIC2.ICCR2.BYTE = IIC2.ICCR2.BYTE & ~0xc0;			/* XgbvRfBV BBSY=0,SCP=0 */
		return( 1 );
	}
	return( 0 );
}
void wait( int msec )
{
	long i;
	for( i=0; i<1000 * ( long )msec; i++ ){
	}
}
