/*
///////////////////////////////////////////////////////////////////////////////////////////////////
//shnQ@rbhvO
//	FileName	SCI.c
//	Version		1.00
//	MCU		H8/3694
//	Work		
//-------------------------------------------------------------------------------------------------
//
//	2007/04/19	Ver1.00
//-------------------------------------------------------------------------------------------------
*/

/*

̃\tgEFA̓t[EFAłB

̃\tgEFAɊւ鎿ɂ܂ẮA
T|[g̑ΏۊOƂȂ܂B

쌠͍쐬ł()kldqL̂Ƃ܂B

̃\tgEFAgpƂɂSĂ̑QɂāA
쐬͈؂̐ӔC𕉂Ȃ̂Ƃ܂B

̃\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ
֎~܂BGȂǂ֏ЉE^̏ꍇ͘A肢v
܂B

@Copyright (C) Hokuto denshi Co,Ltd. 2007

*/



/*
/////////////////////////////////////////////////////////////////////////////////////////
//CN[ht@C錾
*/
/* }CRCu */
#include <machine.h>

/* WbCu */
#include <math.h>

/* IWi */
#include "3694S.h"
#include "Main.h"
#include "SCI.h"


/*
/////////////////////////////////////////////////////////////////////////////////////////
//萔錾
*/
#define VAL_SCI_BRRFIXED	64


/*
/////////////////////////////////////////////////////////////////////////////////////////
//^錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//ϐ錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//}N錾
*/


/*
/////////////////////////////////////////////////////////////////////////////////////////
//֐vg^Cv錾
*/
int Init_SCI ( const unsigned char Ch, const unsigned long Xtal, const unsigned long BaudRate );
int Read_SCI ( const unsigned long Length, unsigned char *Buffer );
int Write_SCI ( const unsigned long Length, const unsigned char *Buffer );


/*
/////////////////////////////////////////////////////////////////////////////////////////
//֐vg^Cv錾
*/


/*
///////////////////////////////////////////////////////////////////////////////
//Init_SCI
//Erbh
//-----------------------------------------------------------------------------
//return int
//	NOERROR		: 
//	ERROR_FATAL	: G[
//-----------------------------------------------------------------------------
//param In	Ch		: VA`l
//param In	Xtal		: NX^(PʁFlg)
//param In	BaudRate	: ʐM[g(PʁFaor)
//-----------------------------------------------------------------------------
//[ l ]
//EH8/3694 ł̓`lP݂̂Ȃ̂ŁAuChv͖
//-----------------------------------------------------------------------------
*/
int Init_SCI (
	const unsigned char Ch,
	const unsigned long Xtal,
	const unsigned long BaudRate
)
{
	/* ϐ錾 */
	unsigned long Denominator;	/*  */
	unsigned long Molecule;		/* q */
	unsigned long Brr;		/* VArbg[gWX^l */
	volatile int i = 0;
	int Result = NOERROR;
	
	
	/*  */
	/* M̋@\~ */
	SCI3.SCR3.BYTE = 0;
	
	
	/* A8bitf[^ApeBȂ */
	SCI3.SMR.BYTE = 0x00;
	
	
	/* [g */
	for ( i = 0; i < 4; ++i )
	{/* NbNZNg[v */
		Denominator = ( unsigned long )( ( unsigned long )VAL_SCI_BRRFIXED * ( unsigned long )( pow (2, ( 2 * i - 1 )) * 10.0 ) * BaudRate ) / 10;
		Molecule = ( (Xtal * 1000000) * 10 );
		Brr = ( (Molecule / Denominator - 10 + 5) / 10 );
		if ( Brr <= 255 )
		{/* BrrK( 0 <= Brr <= 255 )̏ꍇAuCN */
			break;
		}
	}
	if ( i < 4 )
	{/* [gvZ */
		/* [gݒ */
		SCI3.SMR.BIT.CKS = ( unsigned char )i;
		SCI3.BRR = ( unsigned char )Brr;
		
		
		/* Prbgԑҋ@ */
		for ( i = 0; i < 1000; ++i );
		
		
		/* M̋@\Jn */
		SCI3.SCR3.BYTE = 0x30;
		
		
		/* |[g[hؑ */
		IO.PMR1.BIT.TXD = 1;
	}
	else
	{/* [gvZs */
		Result = ERROR_FATAL;
	}
	
	
	/* I */
	return Result;
}


/*
///////////////////////////////////////////////////////////////////////////////
//Read_SCI
//Erbhǂݍ
//-----------------------------------------------------------------------------
//return int
//	>= NOERROR		: M
//	ERROR_FATAL		: G[
//-----------------------------------------------------------------------------
//param In	Length		: M
//param In	*Buffer		: Mf[^
//-----------------------------------------------------------------------------
*/
int Read_SCI (
	const unsigned long Length,
	unsigned char *Buffer
)
{
	/* ϐ錾 */
	int i;
	int Result = NOERROR;
	
	
	/* M[v */
	for ( i = 0; i < Length; ++i )
	{
		/* M҂[v */
		while ( 1 )
		{
			/* G[`FbN */
			if ( (SCI3.SSR.BYTE & 0x38) != 0x00 )
			{/* G[ */
				SCI3.SSR.BYTE &= ~0x38;	/* G[tONA */
				Result = ERROR_FATAL;	/* G[R[hԋp */
				break;
			}
			else if ( SCI3.SSR.BIT.RDRF == 1 )
			{/* ML */
				Buffer[ i ] = SCI3.RDR;
				SCI3.SSR.BYTE = ~0x78;
				break;
			}
		}
		
		/* ʔf */
		if ( Result == NOERROR )
		{/* M */
			Result = i;
		}
		else
		{/* MG[ */
			break;
		}
	}
	
	
	/* I */
	return Result;
}
/*
///////////////////////////////////////////////////////////////////////////////
//Write_SCI
//@VA
//-----------------------------------------------------------------------------
//return int
//	>= NOERROR		: M
//	ERROR_FATAL		: G[
//-----------------------------------------------------------------------------
//param In	Length		: M
//param In	*Buffer		: Mf[^
//-----------------------------------------------------------------------------
*/
int Write_SCI (
	const unsigned long Length,
	const unsigned char *Buffer
)
{
	/* ϐ錾 */
	int i;
	
	
	/* M[v */
	for ( i = 0; i < Length; ++i )
	{
		/* M҂[v */
		while ( SCI3.SSR.BIT.TDRE == 0 ) {}
		
		
		/* f[^M */
		SCI3.TDR = Buffer[ i ];
		
		
		/* M҂ */
		while( SCI3.SSR.BIT.TEND == 0 ) {}
	}
	
	
	/* I */
	return i;
}
