/**
 * @file  ada_if.h
 * @brief ADA-IF(I2Sオーディオ通信）ドライバヘッダ
 *
 * @version: $Id: ada_if.h $
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)～(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *     権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *     いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *     とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *     からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2021
 */

#ifndef __ADA_IF_H__
#define __ADA_IF_H__

#include "hal_data.h"

#include "ada_if_userdef.h"

/*----------------------------------------------------------------------
    定義値
----------------------------------------------------------------------*/

#define FS (48000)                      //サンプリング周波数(48kHz)

#define FIFO_BUF_SIZE (64)
#define TRANSFER_SIZE (32)

#if (USE_CH == 1)

typedef struct{
  float ch0;
} PCM_float;

#if (DATA_BUFFER_SIZE_SAME == 1)

#define DATA_BUFFER_SIZE    (32768)            //128+128=256kB, 入力バッファと出力バッファのサイズを同じとする
#define INPUT_BUFFER_SIZE   DATA_BUFFER_SIZE
#define OUTPUT_BUFFER_SIZE  DATA_BUFFER_SIZE

#else

#define INPUT_BUFFER_SIZE   (32768)            //128kB
#define OUTPUT_BUFFER_SIZE  (32768)            //128kB

#endif

#elif (USE_CH == 2)

typedef struct{
  float ch0;
  float ch1;
} PCM_float;

#if (DATA_BUFFER_SIZE_SAME == 1)

#define DATA_BUFFER_SIZE    (16384)             //128+128=256kB, 入力バッファと出力バッファのサイズを同じとする
#define INPUT_BUFFER_SIZE   DATA_BUFFER_SIZE
#define OUTPUT_BUFFER_SIZE  DATA_BUFFER_SIZE

#else

#define INPUT_BUFFER_SIZE   (16384)             //128kB
#define OUTPUT_BUFFER_SIZE  (16384)             //128kB

#endif

#endif


/*----------------------------------------------------------------------
    関数プロトタイプ
----------------------------------------------------------------------*/

extern void ada_if_init (void);
extern int ada_if_start (void);
extern void ada_if_write_read (void);
extern int ada_if_input_index(int n);
extern int ada_if_output_index(int n);
extern int ada_if_input_index_diff(int n, int m);
extern int ada_if_output_index_diff(int n, int m);

/*----------------------------------------------------------------------
    グローバル変数
----------------------------------------------------------------------*/

extern PCM_float *g_pcm0;
extern PCM_float *g_pcm1;

extern int32_t g_stream_tx_buf[2][FIFO_BUF_SIZE];
extern int32_t g_stream_rx_buf[2][FIFO_BUF_SIZE];

extern volatile bool g_i2s_streaming_ready;
extern volatile unsigned long g_buffer_index;

extern volatile int g_input_index, g_output_index;

extern PCM_float g_zero_data;

extern volatile unsigned long g_sw_state;
extern volatile bool g_sw_push;
extern int g_sw_cancel;

extern volatile bool g_ad_flag;
extern volatile unsigned short g_ad_val[];

extern volatile unsigned long g_led_pattern;
extern volatile unsigned long g_led_pattern_index;


#endif
