/**
 * @file  ada_if_userdef.h
 * @brief ADA-IF(I2Sオーディオ通信）ドライバユーザ定義ヘッダ
 *
 * @version: $Id: ada_if_userdef.h $
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)～(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *     権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *     いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *     とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *     からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2021
 */

#ifndef __ADA_IF_USERDEF_H__
#define __ADA_IF_USERDEF_H__

//ユーザ定義値（※コンパイルオプション、実行中の変更は不可）

//出力ch
#define USE_CH (1)                      //"1"（ch0(Lch)のみ扱う, ch1(Rch)は0出力）または"2"（ch0(Lch), ch1(Rch)両方を扱う）を定義

//データバッファサイズ
#define DATA_BUFFER_SIZE_SAME   (1)     //"0"入力バッファと出力バッファのサイズを変える、"1"入力バッファサイズと出力バッファサイズを同じとする

//FIFOバッファサイズ
#define FIFO_BUFFER_SIZE    (4)         //値を小さくすると入出力のレイテンシーは最小となります
                                        //値が大きい方が処理のオーバヘッドは小さくなります

//出力バッファデータ送信後の挙動
#define OUTPUT_BUFFER_AFTER_SEND    (1) //"0"データを消す、"1"データを消さない


//スイッチ(SW1)の状態を何種類設けるか
#define SW_STATE_NUM    (10)            //ボード上のTEST SWを押す度に g_sw_state が 0-(SW_STATE_NUM-1)に遷移（0はSW2を使用しない）

//ボード上のLED(D7)を使用
#define USE_LED         (1)             //"0"使用しない, "1"LEDを使用する

//ADCを使用する
#define USE_ADC_PORT    (0)             //"0"使用しない, "1"AN000-AN002をvolume1-volume3の読み取り値に使用

//SCIを使用する
#define USE_SCI         (1)             //"0"使用しない, "1"SCIを使用する

//定数定義
#define M_PI    (3.14159265358979)          //pi

#endif
