/**
 * @file  callback.c
 * @brief コールバック関数
 *
 * @version: $Id: callback.c $
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)～(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *     権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *     いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *     とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *     からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2021
 */


/*----------------------------------------------------------------------
  インクルード
----------------------------------------------------------------------*/

#include "hal_data.h"

#include "callback.h"
#include "ada_if/ada_if.h"

/*----------------------------------------------------------------------
    関数プロトタイプ
----------------------------------------------------------------------*/

void agt0_callback (timer_callback_args_t * p_args);

void adc0_callback (adc_callback_args_t * p_args);

void kint_callback (keymatrix_callback_args_t * p_args);

/*----------------------------------------------------------------------
    グローバル変数
----------------------------------------------------------------------*/


/*----------------------------------------------------------------------
    関数定義
----------------------------------------------------------------------*/

void agt0_callback (timer_callback_args_t * p_args)
{
    if (TIMER_EVENT_CYCLE_END == p_args->event)
    {

#if (USE_ADC == 1)
        if(g_ad_flag == false)
        {
            g_ad_flag = true;
            (void) R_ADC_ScanStart(&g_adc0_ctrl);   //A/D conversion start
        }
#endif

#if (USE_LED == 1)

        if(g_led_pattern_index & g_led_pattern) LED_PORT = 1;
        else LED_PORT = 0;

        if((g_led_pattern_index & 0x80000000) || (g_led_pattern_index == 0)) g_led_pattern_index = 0x00000001;
        else g_led_pattern_index <<= 1;
#endif

#if (SW_STATE_NUM != 0)

        if(g_sw_cancel != 0)
        {
            //一度応答したら一定時間経過前の応答はキャンセル
            g_sw_cancel--;
            g_sw_push = false;
        }
        else
        {
            if(g_sw_push == true)
            {
                g_sw_push = false;

                g_sw_state++;

                if(g_sw_state >= SW_STATE_NUM) g_sw_state = 0;

                g_sw_cancel = 3;    //一度応答すると3回（150ms）は応答しない
            }
        }
#endif

    }
}

void adc0_callback (adc_callback_args_t * p_args)
{
    if (ADC_EVENT_SCAN_COMPLETE  == p_args->event)
    {
        g_ad_val[0] = R_ADC0->ADDR[0];
        g_ad_val[1] = R_ADC0->ADDR[1];
        g_ad_val[2] = R_ADC0->ADDR[2];

        g_ad_flag = false;
    }
}

void kint_callback (keymatrix_callback_args_t * p_args)
{
    (void) p_args;

    g_sw_push = true;

}
