/**
 * @file  sci.h
 * @brief SCIドライバヘッダ
 *
 * @version: $Id: sci.h $
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)～(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *     権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *     いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *     とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *     からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2021
 */

#include "ada_if/ada_if_userdef.h"

#ifndef __SCI_H__
#define __SCI_H__

#define FLAG_SET    1
#define FLAG_CLEAR  0

#if (USE_SCI == 1)
#define SCI_SEND_BUF_SIZE   2048
#define SCI_RECV_BUF_SIZE   32
#else
#define SCI_SEND_BUF_SIZE   1
#define SCI_RECV_BUF_SIZE   1
#endif
#define SCI_DATA_EMPTY      0xff

/*----------------------------------------------------------------------
    関数プロトタイプ
----------------------------------------------------------------------*/

extern void sci_init(void);
extern void sci_write_char(unsigned char c);
extern void sci_write_uint8_hex(unsigned char c);
extern void sci_write_uint16_hex(unsigned short s);
extern void sci_write_uint32_hex(unsigned long l);
extern void sci_write_uint8(unsigned char num);
extern void sci_write_uint16(unsigned short num);
extern void sci_write_uint32(unsigned long num);
extern void sci_write_int8(char num);
extern void sci_write_int16(short num);
extern void sci_write_int32(long num);
extern void sci_write_str(char *str);
extern void sci_write_flush(void);
extern unsigned char sci_read_char(void);
extern void sci_read_buf_clear(void);
extern int float2str(float value, int num, char *str);

/*----------------------------------------------------------------------
    グローバル変数
----------------------------------------------------------------------*/

extern volatile unsigned char g_sci_send_buf[];
extern volatile unsigned char g_sci_recv_buf[];
extern volatile unsigned short g_sci_send_buf_index1;
extern volatile unsigned short g_sci_send_buf_index2;
extern volatile unsigned short g_sci_recv_buf_index1;
extern volatile unsigned short g_sci_recv_buf_index2;
extern unsigned char g_sci_send_data;
extern unsigned char g_sci_recv_data;
extern volatile bool g_sci_send_flag;
extern volatile bool g_sci_send_wait;

#endif
