
#include "sound_effect.h"

void delay(int offset, int data_handling_size)
{
	int n;
	short volume1 = (short)g_ad_val[0], volume2 = (short)g_ad_val[1], volume3 = (short)g_ad_val[2];
	int m, d;
	float s, a;

#if (FS < (DATA_BUFFER_SIZE+256))
	//基本的にはサンプリング数(1秒）を基準にディレイを計算
	d = (int)((float)FS * 1.0f * (float)volume1 / 4096.0f);
#else
	//バッファメモリが少ない場合はバッファメモリ量=ディレイの最大値とする
	d = (int)((float)(DATA_BUFFER_SIZE - 256) * 1.0f * (float)volume1 / 4096.0f);
#endif
	a = (float)volume2 / 4096.0f;

	for (n = 0; n < data_handling_size; n++)
	{
		s = g_pcm0[offset + n].ch0;

		 m = offset + n - d;
		if (m < 0)
		{
			m += DATA_BUFFER_SIZE;
		}

		s += g_pcm0[m].ch0 * a;
		
		g_pcm1[offset + n].ch0 = s;
	}
}
