
#include "sound_effect.h"

void distortion(int offset, int data_handling_size)
{
	int n;
	short volume1 = (short)g_ad_val[0], volume2 = (short)g_ad_val[1], volume3 = (short)g_ad_val[2];
	float s;
	float gain, level;

	gain = (float)volume1 / 4096.0f * 100.0f;
	level = (float)volume2 / 4096.0f;

	for (n = 0; n < data_handling_size; n++)
	{
		s = g_pcm0[offset + n].ch0 * gain;
		if (s > 1.0f)
		{
			s = 1.0f;
		}
		else if (s < -1.0f)
		{
			s = -1.0f;
		}
		g_pcm1[offset + n].ch0 = s * level;
	}
}
