
#include "sound_effect.h"
#include <math.h>

#define NOT_USE_POW_FUNCTION
//GCCのpowf関数は非常に実行速度が遅く(約5us@120MHz)計算が間に合わないので
//powfを使わない方法で計算する

void reverb(int offset, int data_handling_size)
{
	int n;
	short volume1 = (short)g_ad_val[0], volume2 = (short)g_ad_val[1], volume3 = (short)g_ad_val[2];
	int m, d, i;
	float s, a;

#ifdef NOT_USE_POW_FUNCTION
	float pow_ar[11];   //ar[0]は未使用
#endif

#if (FS < (DATA_BUFFER_SIZE+256))
	//基本的にはサンプリング数(1秒）を基準にディレイを計算
	d = (int)((float)FS * 0.1f * (float)volume1 / 4096.0f);
#else
	//バッファメモリが少ない場合はバッファメモリ量=ディレイの最大値とする
	d = (int)((float)(DATA_BUFFER_SIZE - 256) * 0.1f * (float)volume1 / 4096.0f);
#endif
	a = (float)volume2 / 4096.0f;

#ifdef NOT_USE_POW_FUNCTION
	pow_ar[1] = a;
	for (i = 2; i <= 10; i++)
	{
	    pow_ar[i] = pow_ar[i-1] * a;
	}
#endif

	for (n = 0; n < data_handling_size; n++)
	{
		s = g_pcm0[offset + n].ch0;
		
		for (i = 1; i <= 10; i++)
		{
			m = offset + n - d * i;
			if (m < 0)
			{
			    m += DATA_BUFFER_SIZE;
			}
#ifdef NOT_USE_POW_FUNCTION
			s += g_pcm0[m].ch0 * pow_ar[i];
#else
			//オリジナル
			s += g_pcm0[m].ch0 * powf(a, (float)i);
#endif
		}

		g_pcm1[offset + n].ch0 = s;
	}
}
