
#include "sound_effect.h"
#include <math.h>

void tremolo(int offset, int data_handling_size)
{
	int n;
	short volume1 = (short)g_ad_val[0], volume2 = (short)g_ad_val[1], volume3 = (short)g_ad_val[2];
	float depth, rate;
	float delta, a, x = 0.0f;

	depth = (float)volume1 / 4096.0f;
	rate = (float)volume2 / 4096.0f * 10.0f;

	for (n = 0; n < data_handling_size; n++)
	{
		a = 1.0f + depth * sinf(2.0f * (float)M_PI * x);

		delta = rate / (float)FS;
		x += delta;
		if (x >= 1.0f)
		{
			x -= 1.0f;
		}

		g_pcm1[offset + n].ch0 = g_pcm0[offset + n].ch0 * a;
	}
}
