
#include "sound_effect.h"
#include <math.h>

void vibrart(int offset, int data_handling_size)
{
	int n;
	short volume1 = (short)g_ad_val[0], volume2 = (short)g_ad_val[1], volume3 = (short)g_ad_val[2];
	int m0, m1;
	float depth, rate;
	float s, s0, s1, delta, tau, d, t, p, x = 0.0;

	d = (float)FS * 0.002f;
	depth = (float)FS * 0.002f * (float)volume1 / 4096.0f;
	rate = (float)volume2 / 4096.0f * 10.0f;

	for (n = 0; n < data_handling_size; n++)
	{
		tau = d + depth * sinf(2.0f * (float)M_PI * x);

		delta = rate / FS;
		x += delta;
		if (x >= 1.0f)
		{
			x -= 1.0f;
		}

		t = (float)(offset + n) - tau;
		if (t < 0.0f)
		{
			t += (float)DATA_BUFFER_SIZE;
		}

		m0 = (int)t;
		m1 = m0 + 1;
		if (m1 >= DATA_BUFFER_SIZE)
		{
			m1 -= DATA_BUFFER_SIZE;
		}
		p = t - (float)m0;

		s0 = g_pcm0[m0].ch0;
		s1 = g_pcm0[m1].ch0;

		s = p * s1 + (1.0 - p) * s0;

		g_pcm1[offset + n].ch0 = s;
	
	}
}

