/*
 * @file  intr.c
 * @brief HSBRX65_IO_BOARD荞ݏ
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)-(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2024
 */

/*----------------------------------------------------------------------
	CN[h
----------------------------------------------------------------------*/
#include	"r_smc_entry.h"
#include	"io_board.h"

/*----------------------------------------------------------------------
	荞݃R[obN֐vg^Cv錾
----------------------------------------------------------------------*/
void (*cmt3_callback) (void);
void (*rtc_callback) (void);
void (*adc_callback) (void);
void (*sw8_callback) (void);
void (*sw9_callback) (void);
void (*sw10_callback) (void);
void (*tpu2a_callback) (void);
void (*tpu2b_callback) (void);

/*----------------------------------------------------------------------
	荞݊֐
----------------------------------------------------------------------*/
void intr_cmt3(void)
{
	if (g_function_use[IOBOARD_ADC] == ENABLE)
	{
		//A/Dϊ̋Ns
	
		if (g_adc_flag == 0)			//A/DϊłȂꍇ
		{
			R_Config_S12AD0_Start();	//A/DϊN
			g_adc_flag = 1;				//A/DϊtO𗧂Ă
		}
	}
	
	if (g_function_use[IOBOARD_LED7SEG] == ENABLE)
	{
		//7ZOLED̕\̈ړs
		
		/*
		 *	PA0-PA7 ZOM
		 *  P74-P77 COMM
		 *  P70-P73PODRl͕ύXȂ
		 */
		
		static int com = 0;
		
		switch (com)
		{
			case 1:
			
				//COM1SEGf[^Zbg & P74(COM1)I
				PORTA.PODR.BYTE = 0x00;									//U
				PORT7.PODR.BYTE &= 0x0F;
				PORT7.PODR.BYTE |= 0x10;								//COM1I
				PORTA.PODR.BYTE = g_led7seg_data[IOBOARD_LED7SEG_COM1];	//COM1̃f[^ZOMɃZbg
				com = 2;												//ɕ\COM
				break;
				
			case 2:
			
				//COM2SEGf[^Zbg & P75(COM2)I
				PORTA.PODR.BYTE = 0x00;									//U
				PORT7.PODR.BYTE &= 0x0F;
				PORT7.PODR.BYTE |= 0x20;								//COM2I
				PORTA.PODR.BYTE = g_led7seg_data[IOBOARD_LED7SEG_COM2];	//COM2̃f[^ZOMɃZbg
				com = 3;												//ɕ\COM
				break;
				
			case 3:
			
				//COM3SEGf[^Zbg & P76(COM3)I
				PORTA.PODR.BYTE = 0x00;									//U
				PORT7.PODR.BYTE &= 0x0F;
				PORT7.PODR.BYTE |= 0x40;								//COM3I
				PORTA.PODR.BYTE = g_led7seg_data[IOBOARD_LED7SEG_COM3];	//COM3̃f[^ZOMɃZbg
				com = 4;												//ɕ\COM
				break;

			case 4:
			
				//COM4SEGf[^Zbg & P77(COM4)I
				PORTA.PODR.BYTE = 0x00;									//U
				PORT7.PODR.BYTE &= 0x0F;
				PORT7.PODR.BYTE |= 0x80;								//COM4I
				PORTA.PODR.BYTE = g_led7seg_data[IOBOARD_LED7SEG_COM4];	//COM4̃f[^ZOMɃZbg
				com = 1;												//ɕ\COM
				break;
			
			default:	//JnCOM1I
				com = 1;
				break;
		}
	}
	
	if (g_function_use[IOBOARD_MATRIXSW] == ENABLE)
	{
		//}gbNXXCb`̓ǂݎROWI̕ύXs
		
		/*
		 *	P60-P63 COLMíj
		 *  P64-P67 ROWMiój
		 */ 
		
		static int row = 0;
	
		unsigned char port6 = PORT6.PIDR.BYTE;
		
		switch (row)
		{
			case 1:
	
				//P64(ROW1)IĂԁSW11-SW14̓ǂݎ & P65(ROW2)I
				g_matrixsw[IOBOARD_SW11] = port6 & 0x1;
				g_matrixsw[IOBOARD_SW12] = (port6 & 0x2) ? 1 : 0;
				g_matrixsw[IOBOARD_SW13] = (port6 & 0x4) ? 1 : 0;
				g_matrixsw[IOBOARD_SW14] = (port6 & 0x8) ? 1 : 0;

				PORT6.PODR.BYTE = 0xD0;			//ROW2I
				row = 2;						//ROW2Ȉێ
				break;
				
			case 2:

				//P65(ROW2)IĂԁSW15-SW18̓ǂݎ & P66(ROW3)I
				g_matrixsw[IOBOARD_SW15] = port6 & 0x1;
				g_matrixsw[IOBOARD_SW16] = (port6 & 0x2) ? 1 : 0;
				g_matrixsw[IOBOARD_SW17] = (port6 & 0x4) ? 1 : 0;
				g_matrixsw[IOBOARD_SW18] = (port6 & 0x8) ? 1 : 0;
		
				PORT6.PODR.BYTE = 0xB0;			//ROW3I
				row = 3;						//ROW3Ȉێ
				break;

			case 3:
			
				//P66(ROW3)IĂԁSW19-SW22̓ǂݎ & P67(ROW4)I
				g_matrixsw[IOBOARD_SW19] = port6 & 0x1;
				g_matrixsw[IOBOARD_SW20] = (port6 & 0x2) ? 1 : 0;
				g_matrixsw[IOBOARD_SW21] = (port6 & 0x4) ? 1 : 0;
				g_matrixsw[IOBOARD_SW22] = (port6 & 0x8) ? 1 : 0;
		
				PORT6.PODR.BYTE = 0x70;			//ROW4I
				row = 4;						//ROW4Ȉێ
				break;

			case 4:
				//P67(ROW4)IĂԁSW23-SW26̓ǂݎ & P64(ROW1)I
				g_matrixsw[IOBOARD_SW23] = port6 & 0x1;
				g_matrixsw[IOBOARD_SW24] = (port6 & 0x2) ? 1 : 0;
				g_matrixsw[IOBOARD_SW25] = (port6 & 0x4) ? 1 : 0;
				g_matrixsw[IOBOARD_SW26] = (port6 & 0x8) ? 1 : 0;
		
				PORT6.PODR.BYTE = 0xE0;			//ROW1I
				row = 1;						//ROW1Ȉێ
				break;
				
			default:
				PORT6.PODR.BYTE = 0xE0;			//JnP64(ROW1)I
				row = 1;
				break;
		}
	}
	
	//R[obN֐̒g̓AvP[Vɒ`
	cmt3_callback();
}

void intr_rtc(void)
{
	setpsw_i();		//d荞݋
	
	//R[obN֐̒g̓AvP[Vɒ`
	rtc_callback();
}

void intr_adc(void)
{
	//A/DϊI荞݊֐
	
	unsigned short result;
	static unsigned short index = 0;
	static unsigned short data_history_buf[IOBOARD_ADC_AVERAGE_NUM] = {0};
	static unsigned long sum = 0;
	
	R_Config_S12AD0_Get_ValueResult(ADCHANNEL0, &result);	//A/Dϊʂ̓ǂݏo
	
	g_adc_flag = 0;						//A/DϊtO𗎂Ƃ
	
	setpsw_i();		//d荞݋
	
#if (IOBOARD_ADC_AVERAGE_NUM > 1)

	//ړς̎Zo
	
	//ԌÂf[^vȂ
	sum -= data_history_buf[index];
	
	//obt@Ɍ݂̃f[^i[
	data_history_buf[index] = result;
	
	//ړς̍vlɍŐṼf[^Z
	sum += data_history_buf[index];
	
	//CfbNXi߂
	index++;
	if (index >= IOBOARD_ADC_AVERAGE_NUM)
	{
		index = 0;
	}
	
	/*
	 * data_history_bufւ̃f[^i[ꏄ܂ł́Al0̈ړςƂȂ
	 */
	 
	g_adc_result = (unsigned short)(sum / IOBOARD_ADC_AVERAGE_NUM);		//A/DϊʂړϒlƂ
	
	/*
	 * ADC_AVERAGE_NUM 2ׂ̂ƂȂl]܂iœKɂ菜ZrbgVtg߂ɒuj
	 */

#else

	//ړςgpȂ
	
	g_adc_result = result;

#endif

	//R[obN֐̒g̓AvP[Vɒ`
	adc_callback();
}

void intr_irq4(void)
{
	//SW10荞݊֐
	
	setpsw_i();		//d荞݋
	
	//R[obN֐̒g̓AvP[Vɒ`
	sw10_callback();
}

void intr_irq13(void)
{
	//SW9荞݊֐
	
	setpsw_i();		//d荞݋
	
	//R[obN֐̒g̓AvP[Vɒ`
	sw9_callback();
}

void intr_irq15(void)
{
	//SW8荞݊֐
	
	setpsw_i();		//d荞݋
	
	//R[obN֐̒g̓AvP[Vɒ`
	sw8_callback();
}

void intr_tpu2a(void)
{
	//TPU2̎I
	
	//TGRA/BWX^̍XV
	
	/*
	 * TGRAWX^͐^C~Oł͂ȂAITGRARyA}b`I^C~OōXV
	 */
	 
	if (TPU2.TGRA != g_tpu2_tgra)
	{
		TPU2.TGRA = g_tpu2_tgra;
	}
	
	/*
	 * TGRBWX^́A^C}JEgl1000̃^C~O
	 * 2000500̗lɕύXidutyύXjꍇ́AI܂ŃRyA}b`ȂȂ
	 * idutyɕύXɂS炸A1ȏ㒷o̓^C~OĂ܂j
	 * lύX1̃^C~OŁA̐LтP[X̂ŁAWX^l̕ύX͌܂^C~Oōs
	 */
	
	if (TPU2.TGRB != g_tpu2_tgrb)
	{
		TPU2.TGRB = g_tpu2_tgrb;
	}
	
	//R[obN֐̒g̓AvP[Vɒ`
	tpu2a_callback();
}

void intr_tpu2b(void)
{
	//TPU2̃RyA}b`B
	
	//R[obN֐̒g̓AvP[Vɒ`
	tpu2b_callback();
}