/*
 * @file  io_board.c
 * @brief HSBRX65_IO_BOARDhCo
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)-(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2024
 */

/*----------------------------------------------------------------------
	CN[h
----------------------------------------------------------------------*/
#include	"r_smc_entry.h"
#include	"io_board.h"

/*----------------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------------*/
//CMT3ŏe@\L邩ۂ
volatile int g_function_use[IOBOARD_CMT3_FUNCTION_NUM] = {0};

//ADC
volatile int g_adc_flag = 0;
volatile unsigned short g_adc_result;

//7ZOLED
volatile unsigned char g_led7seg_data[IOBOARD_LED7SEG_COM] = {0};

//}gbNXXCb`
volatile unsigned char g_matrixsw[IOBOARD_MATRIXSW_NUM] = {0};

//TPU2.TGRA/BWX^
volatile unsigned short g_tpu2_tgra = 60000 - 1;	//1.024b
volatile unsigned short g_tpu2_tgrb = 30000 - 1;	//duty 50&

/*----------------------------------------------------------------------
	֐vg^Cv錾
----------------------------------------------------------------------*/
//vbVXCb`(SW0-SW7)
int push_sw_init(void);
unsigned char push_sw_read(void);

//vbVXCb`(SW8-SW10), 荞݂ŏXCb`
int intr_push_sw_init(int timing);
int intr_push_sw_start(void);
int intr_push_sw_stop(void);

//LED(LED0-LED7)
int led_init(void);
int led_set(unsigned char led);

//uU[(B1), JP2:P17i㑤V[gj
int buzzer_freq_set(unsigned short freq);
int buzzer_on(void);
int buzzer_off(void);

//LED8, JP1:P15iV[gj
int led8_cycle_set(unsigned short cycle);
int led8_duty_set(float duty);
int led8_on(void);
int led8_off(void);

//XebsO[^
int stepping_motor_init(void);
int stepping_motor_start(int direction);
int stepping_motor_stop(void);
int stepping_motor_step_move(int direction);
int stepping_motor_drive(unsigned char pattern);

//ADC
int adc_start(void);
int adc_stop(void);
unsigned short adc_val(void);

//7ZOLED
int led7seg_init(void);
int led7seg_start(void);
int led7seg_stop(void);
int led7seg_segument_data_set(unsigned char column, unsigned char seg, unsigned char seg_on_off);
int led7seg_disp_hex(unsigned short data);
int led7seg_disp_num(short data, unsigned char dp);

//}gbNXXCb`
int matrixsw_init(void);
int matrixsw_start(void);
int matrixsw_stop(void);

/*----------------------------------------------------------------------
	֐`
----------------------------------------------------------------------*/
int push_sw_init(void)
{
	//vbVXCb`֐
	
	//SW0-SW7̏s܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	PORTD.PDR.BYTE = 0x00;	//[q̓[hɃZbg
	
	return RET_SUCCESS;
}

unsigned char push_sw_read(void)
{
	//vbVXCb`ǂݎ֐
	
	//SW0-SW7̏Ԃǂݎ܂
	
	//
	//  Ȃ
	
	//߂l
	//  SWǂݎ茋(OFF:bit=1, ON:bit=0)
	
	return PORTD.PIDR.BYTE;
}

int intr_push_sw_init(int timing)
{
	//荞ݑΉvbVXCb`֐
	
	//SW8-SW10̊荞݂̃GbWݒ肵܂
	
	//
	//  timing
	//    0 : {^ۂɊ荞݂|܂
	//    1 : {^łԂ痣ۂɊ荞݂|܂
	//    2 : ہAۂ̗荞݂|܂
	
	//߂l
	//  I : RET_SUCCESS(0)
	//  G[ : RET_ERROR(-1)
	
	/*
	 * {֐sȂꍇX}[gERtBO[^ݒ̒liۂɊ荞݁jƂȂ܂
	 */
	 
	 unsigned char val;
	 
	 if (timing == 0)
	 {
		 val = 0x1;		//GbW
	 }
	 else if (timing == 1)
	 {
		 val = 0x2;		//オGbW
	 }
	 else if (timing == 2)
	 {
		 val = 0x3;		//GbW
	 }
	 else
	 {
		 return RET_ERROR;
	 }
	 
	ICU.IRQCR[4].BIT.IRQMD = val;
	ICU.IRQCR[13].BIT.IRQMD = val;
	ICU.IRQCR[15].BIT.IRQMD = val;
	
	return RET_SUCCESS;
	
}

int intr_push_sw_start(void)
{
	//荞ݑΉvbVXCb`Jn֐
	
	//SW8-SW10̊荞݂̗Ls܂
	
	// Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	R_Config_ICU_IRQ4_Start();		//SW10
	R_Config_ICU_IRQ13_Start();		//SW9
	R_Config_ICU_IRQ15_Start();		//SW8
	
	return RET_SUCCESS;
}

int intr_push_sw_stop(void)
{
	//荞ݑΉvbVXCb`~֐
	
	//SW8-SW10̊荞݂̖s܂
	
	// Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	R_Config_ICU_IRQ4_Stop();		//SW10
	R_Config_ICU_IRQ13_Stop();		//SW9
	R_Config_ICU_IRQ15_Stop();		//SW8
	
	return RET_SUCCESS;
}

int led_init(void)
{
	//LED֐
	
	//LED0-LED7̏s܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	PORTE.PODR.BYTE = 0xFF;		//Ԃ͏
	PORTE.PDR.BYTE = 0xFF;
	
	return RET_SUCCESS;
}

int led_set(unsigned char led)
{
	//LEDݒ֐
	
	//LED0-LED7̏Ԃݒ肵܂
	
	//
	//  led : LEDݒl(bit=0:OFF, bit=1:ON)
	
	//߂l
	//  RET_SUCCESS(0)
	
	PORTE.PODR.BYTE = ~led;
	
	return RET_SUCCESS;
}

int buzzer_freq_set(unsigned short freq)
{
	//uU[̎gݒ֐
	
	//
	//  freq : ݒg
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * ݒ\Ȏg300-8000[Hz]ł
	 * 8bit^C}gpĂ邽߁Aݒ荏݂͍rȂ܂
	 * 300̒lݒ肵ꍇ́A300
	 * 8000ȏ̒lݒ肵ꍇ́A8000ɐݒ肵܂
	 * iTMR^C}ƂẮA228.9-29.3kHz͈̔́j
	 */
	 
	 const unsigned short freq_min = 300;
	 const unsigned short freq_max = 8000;
	 
	 unsigned char reg;
	 
	 if (freq < freq_min) freq = freq_min;
	 else if (freq > freq_max) freq = freq_max;
	 
	 float clock_cycle_time = 1.0f / (PCLKB * 1.0e6f) * 1024.0f;	//TMR^C}1JEg̃TCN, 1024
	 float cycle_time = 1.0f / freq;
	 
	 reg = (unsigned char)(cycle_time / clock_cycle_time) - 1;
	 
	 TMR1.TCORB = reg / 2;		//RyA}b`BWX^͎WX^1/2ɐݒ肷iduty 50%ŋ쓮j
	 TMR1.TCORA = reg;
	 
	 /*
	  * TCORB > TCORAƂȂƁAg`̓gOȂ
	  * TCORBɍXV
	  */
	 
	 /*
	  * TCORA,TCORB̏^C~Oł́ARyA}b`͍sȂ
	  * {֐Ă΂ꂽ^C~OŔg`ɔP[X
	  * {֐ɒZŘAŌĂ΂ꂽꍇAo͔g`ɖ炩ɔ
	  * ̏ꍇ́AuU[ُ̈킪Fł郌x
	  * ig`}~ꍇ́AWX^̍XV^C~O𐏎RyA}b`荞݂̌
	  *  ɕςƂ΍􂪂邪A{֐ł͊֐Ăяöu̔g`͋ej
	  */
	 
	return RET_SUCCESS;
}

int buzzer_on(void)
{
	//uU[Jn
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	R_Config_TMR1_Start();
	
	return RET_SUCCESS;
}

int buzzer_off(void)
{
	//uU[~
	
	//
	// Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	R_Config_TMR1_Stop();
	
	return RET_SUCCESS;
}

int led8_cycle_set(unsigned short cycle)
{
	//LED8̎ݒ֐
	
	//
	//  cycle : TCN(1-65535)
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * TGRBWX^́A^C}JEgl1000̃^C~O
	 * 2000500̗lɕύXꍇ́AI܂ŃRyA}b`ȂȂ
	 * lύX1̂݁A̐LтP[X̂ŁAWX^l̕ύX͌܂^C~Oōs
	 */
	 
	/*
	 * {֐duty͐́iHԁjƂl
	 */
	 
	if (cycle == 0) cycle = 1;
	
	/*
	 * (TGRA)̍Œ1
	 * RyA}b`(TGRB)̍Œ0
	 *  TGRA=1, TGRB=0̎́A2TCN, ؂芷^C~O1TCNi29kHz, duty=0.5j
	 * duty̌vŹATGRx1Zlōs
	 */
	
	float duty = (float)(g_tpu2_tgrb + 1) / (float)(g_tpu2_tgra + 1);
	
	g_tpu2_tgra = cycle;
	g_tpu2_tgrb = (unsigned short)(cycle * duty);		//ύXĂduty͕ύXO̒lێ

	return RET_SUCCESS;
}

int led8_duty_set(float duty)
{
	//LED8̎ݒ֐
	
	//
	//  duty : duty(0-1)
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * ̒lw肵ꍇ0
	 * 1ȏ̒lw肵ꍇ́A1ɐݒ肵܂
	 */
	 
	 if (duty < 0) duty = 0.0f;
	 else if (duty > 1) duty = 1.0f;
	 
	 /*
	  * n܂H, RyA}b`Lo͂Ȃ̂ŁA
	  * TGRB = TGRAij * duty
	  * ƂȂ邪ALED8Lœ_Ȃ̂
	  * 1.0 - dutyŃWX^l߂
	  * duty <-> TGRB : ]
	  */
	  
	 g_tpu2_tgrb = (unsigned short)(g_tpu2_tgra * (1.0f - duty));
	 
	 return RET_SUCCESS;
}

int led8_on(void)
{
	//LED8̓_ŊJn
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	R_Config_TPU2_Start();
	
	return RET_SUCCESS;
}

int led8_off(void)
{
	//LED8̓_Œ~
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	unsigned char tior;
	
	R_Config_TPU2_Stop();
	
	//LED8_Ƀ^C}~ꍇALED8
	
	tior = TPU2.TIOR.BYTE;
	
	TPU2.TIOR.BYTE = 0;
	
	TPU2.TIOR.BYTE = tior;

	return RET_SUCCESS;
}

int stepping_motor_init(void)
{
	//XebsO[^
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * PB4-PB7:o͒[q
	 */
	 
	PORTB.PODR.BYTE &= 0x0F;	//PB4-PB7o=L
	PORTB.PDR.BYTE |= 0xF0;		//PB4-PB7o͗L
	
	return RET_SUCCESS;
}

int stepping_motor_stop(void)
{
	//XebsO[^]~
	
	//XebsO[^쓮gWX^OFF䂵܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)

	
	PORTB.PODR.BYTE &= 0x0F;			//PB4-PB7o=L
	
	return RET_SUCCESS;
}

int stepping_motor_step_move(int direction)
{
	//XebsO[^̃XebvύX܂
	
	//
	//  direction
	//    1 : ]
	//    -1 : t]
	
	//߂l
	//  RET_SUCCESS(0)
	//  G[ : RET_ERROR(-1)
	
	static int local_pattern = 0;
	
	if ((direction != 1) && (direction != -1))
	{
		return RET_ERROR;
	}
	
	//p^[directionɉĕς
	if (direction == 1)
	{
		local_pattern++;
	}
	else if (direction == -1)
	{
		local_pattern--;
	}
	
	//p^[0-3͈̔͂Ƃ
	if (local_pattern >= 4)
	{
		local_pattern = 0;
	}
	else if (local_pattern < 0)
	{
		local_pattern = 3;
	}
	
	stepping_motor_drive((unsigned char)local_pattern);
	
	return RET_SUCCESS;
}

int stepping_motor_drive(unsigned char pattern)
{
	
	//XebsO[^̈p^[w肵ʒuɐݒ肵܂
	
	//
	//  pattern
	//    0-3̈p^[
	
	//߂l
	//  RET_SUCCESS(0)
	
	//PB7 b3
	//PB6 b2
	//PB5 b1
	//PB4 b0
	
	unsigned char port = 0;
	
	switch(pattern)
	{
		case 0:
			//1010
			port = 0xA0;
			break;
			
		case 1:
			//1001
			port = 0x90;
			break;
			
		case 2:
			//0101
			port = 0x50;
			break;
		
		case 3:			
			//0110
			port = 0x60;
			break;
			
		default:
			break;
	}
	
	//PB7-PB4̂ݕύX
	PORTB.PODR.BYTE = (PORTB.PODR.BYTE & 0x0F) | port;
	
	return RET_SUCCESS;
}

int adc_start(void)
{
	//A/Dϊ̒IȎsJn܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * A/DΐACMT3̃^C~OŕϊJnws܂
	 * iADČʂ́AA/DϊI荞݂ŉj
	 */
	
	g_function_use[IOBOARD_ADC] = ENABLE;
	
	return RET_SUCCESS;
}

int adc_stop(void)
{
	//A/Dϊ̒IȎs~܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	g_function_use[IOBOARD_ADC] = DISABLE;
	
	return RET_SUCCESS;
}

unsigned short adc_val(void)
{
	//A/Dϊ̌ʂԂ܂
	
	//
	//  Ȃ
	
	//߂l
	//  A/Dϊl(0-0xFFF)
	
	/*A/Dϊ̌ʂ́AړςvZlƂȂ܂
	 */
	
	return g_adc_result;
}

int led7seg_init(void)
{
	//ZOgLED֐
	
	//7ZOLED̏s܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	PORTA.PODR.BYTE = 0x00;		//SEGM
	PORTA.PDR.BYTE = 0xFF;
	
	PORT7.PODR.BYTE = 0x00;		//COMM
	PORT7.PDR.BYTE = 0xF0;
	
	return RET_SUCCESS;
}

int led7seg_start(void)
{
	//7ZOLED̒Iȕ\XVJn܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * 7ZOLED̕\XViCOMM؂ւj́ACMT3̃^C~Oōs܂
	 */
	
	g_function_use[IOBOARD_LED7SEG] = ENABLE;
	
	return RET_SUCCESS;
}

int led7seg_stop(void)
{
	//7ZOLED̒Iȕ\XV~܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	g_function_use[IOBOARD_LED7SEG] = DISABLE;
	
	//\͏
	PORTA.PODR.BYTE = 0x00;		//SEGM
	PORT7.PODR.BYTE = 0x00;		//COMM
	
	return RET_SUCCESS;
}

int led7seg_segument_data_set(unsigned char column, unsigned char seg, unsigned char seg_on_off)
{
	//ZOgLEDZOglύX֐
	
	//7ZOLED̃ZOgPʂł̃f[^ύXs܂
	//7ZOLED̃ZOg̃O[oϐɌʂf܂
	
	//Cӂ̕\sۂɎgp
	
	//
	//  column : 1-4ڂ̑I
	//  seg : f[^ύXZOg, 'A'-'G', 'P'(DP)
	//  seg_on_off : 0̏ꍇ͏, 1̏ꍇ͓_ 
	
	//߂l
	//  I : RET_SUCCESS(0)
	//  G[ŃO[oϐ̕ύXsȂ : RET_ERROR(-1)
	
	unsigned char seg_data;
	
	if (column < 1) return RET_ERROR;
	if (column > 4) return RET_ERROR;
	
	//삷ZOg̎w
	switch(seg)
	{
		case 'A':
			seg_data = 0x01;	//SEG A -> PA0
			break;
		
		case 'B':
			seg_data = 0x02;	//SEG B -> PA1
			break;
	
		case 'C':
			seg_data = 0x04;	//SEG C -> PA2
			break;
		
		case 'D':
			seg_data = 0x08;	//SEG D -> PA3
			break;
		
		case 'E':
			seg_data = 0x10;	//SEG E -> PA4
			break;
		
		case 'F':
			seg_data = 0x20;	//SEG F -> PA5
			break;
	
		case 'G':
			seg_data = 0x40;	//SEG G -> PA6
			break;

		case 'P':
			seg_data = 0x80;	//SEG DP -> PA7
			break;
			
		default:
			return RET_ERROR;
			break;
	}
	
	switch(seg_on_off)
	{
		case 0:
			g_led7seg_data[column - 1] &= ~seg_data;		//f[^ύX錅̃ZOgf[^bit0ɕύX
			break;
		
		case 1:
			g_led7seg_data[column - 1] |= seg_data;			//f[^ύX錅̃ZOgf[^bit1ɕύX
			break;
		
		default:
			return RET_ERROR;
			break;
	}
	
	return RET_SUCCESS;
}

int led7seg_disp_hex(unsigned short data)
{
	//ZOgLED\֐
	
	//7ZOLED4HEXf[^ŕ\܂
	//\0-9, A-F̃f[^Ώۂł
	//7ZOLED̃ZOg̃O[oϐɌʂf܂
	
	//
	//  data : \f[^
	
	//߂l
	//  I : RET_SUCCESS(0)
	
	//\
	//data = 0x1234@-> 1234
	//data = 0xABCD  -> AbCd
	
	int i;
	
	for (i=0; i<4; i++)
	{
		switch ((data >> (i*4)) & 0xF)			//ʂ4bitPʂŐ؂oăf[^
		{
			case 0:
				g_led7seg_data[i] = 0x3F;		//0\
				break;
				
			case 1:
				g_led7seg_data[i] = 0x06;		//1\
				break;
		
			case 2:
				g_led7seg_data[i] = 0x5B;		//2\
				break;
				
			case 3:
				g_led7seg_data[i] = 0x4F;		//3\
				break;
				
			case 4:
				g_led7seg_data[i] = 0x66;		//4\
				break;
				
			case 5:
				g_led7seg_data[i] = 0x6D;		//5\
				break;
				
			case 6:
				g_led7seg_data[i] = 0x7D;		//6\
				break;
				
			case 7:
				g_led7seg_data[i]= 0x07;		//7\
				break;
				
			case 8:
				g_led7seg_data[i] = 0x7F;		//8\
				break;
				
			case 9:
				g_led7seg_data[i] = 0x6F;		//9\
				break;
				
			case 0xA:
				g_led7seg_data[i] = 0x77;		//A\
				break;
				
			case 0xB:
				g_led7seg_data[i] = 0x7C;		//b\
				break;
				
			case 0xC:
				g_led7seg_data[i] = 0x39;		//C\
				break;
				
			case 0xD:
				g_led7seg_data[i] = 0x5E;		//d\
				break;
				
			case 0xE:
				g_led7seg_data[i] = 0x79;		//E\
				break;
				
			case 0xF:
				g_led7seg_data[i] = 0x71;		//F\
				break;
				
			default:
				break;
		}
	}
	
	return RET_SUCCESS;
}

int led7seg_disp_num(short data, unsigned char dp)
{
	//ZOgLED\֐
	
	//l7ZOLEDŕ\܂
	//7ZOLED̃ZOg̃O[oϐɌʂf܂
	
	//
	//  data : \f[^(-999 - 9999 L)
	//  dp : _\(0-4L, 1͍ŉʌɏ_\, 0͏_\Ȃj
	
	//߂l
	//  I : RET_SUCCESS(0)
	//  G[ŃO[oϐ̕ύXsȂ : RET_ERROR(-1)
	
	//\
	//data = 1234, dp=2 -> 123.4
	
	int i;
	short abs_num;
	unsigned char num[4];
	
	if (data < -999) return RET_ERROR;
	if (data > 9999) return RET_ERROR;
	
	if (dp > 4) return RET_ERROR;
	
	//̃f[^ɕ
	abs_num = data;
	if (data < 0)
	{
		abs_num *= -1;	//̏ꍇ͐Βl
	}
	
	num[3] = (unsigned char)(abs_num / 1000);
	abs_num -= num[3] * 1000;
	num[2] = (unsigned char)(abs_num / 100);
	abs_num -= num[2] * 100;
	num[1] = (unsigned char)(abs_num / 10);
	abs_num -= num[1] * 10;
	num[0] = (unsigned char)abs_num;
	
	//̎_num[]ɂ
	//data = 12̂Ƃ
	//num[3] = 0
	//num[2] = 0
	//num[1] = 1
	//num[0] = 2
	//Ă
	
	//0012̎__12i_͋󔒁jƕ\
	//ŏʌXL0ł΁A󔒕\ɒuA0ȊOł΃XLIiȍ~̒l͕\j
	//ŉʌ͏ɕ\
	for (i=3; i>=1; i--)
	{
		if (num[i] == 0)
		{
			num[i] = 0xFF;		//󔒕\
		}
		else
		{
			//0ȊO̒lł΃XLI
			//1001̏ꍇAr0͕\Ώ
			break;
		}
	}	
	
	//̏ꍇ͍ŉʌXLčŏɌ󔒂'-'ɒu
	if (data < 0)
	{
		for (i=0; i<4; i++)
		{
			if (num[i] == 0xff)
			{
				num[i] = 0x80;			//'-'\
				break;
			}
		}
	}
	
	for (i=0; i<4; i++)
	{
		switch (num[i])
		{
			case 0:
				g_led7seg_data[i] = 0x3F;		//0\
				break;
				
			case 1:
				g_led7seg_data[i] = 0x06;		//1\
				break;
		
			case 2:
				g_led7seg_data[i] = 0x5B;		//2\
				break;
				
			case 3:
				g_led7seg_data[i] = 0x4F;		//3\
				break;
				
			case 4:
				g_led7seg_data[i] = 0x66;		//4\
				break;
				
			case 5:
				g_led7seg_data[i] = 0x6D;		//5\
				break;
				
			case 6:
				g_led7seg_data[i] = 0x7D;		//6\
				break;
				
			case 7:
				g_led7seg_data[i]= 0x07;		//7\
				break;
				
			case 8:
				g_led7seg_data[i] = 0x7F;		//8\
				break;
				
			case 9:
				g_led7seg_data[i] = 0x6F;		//9\
				break;
				
			case 0xFF:
				g_led7seg_data[i] = 0x00;		//
				break;
				
			case 0x80:
				g_led7seg_data[i] = 0x40;		//SEG G ̂ݓ_ '-'\
				break;
				
			default:
				break;
		}
	}
	
	//_̕\
	if (dp != 0)
	{
		led7seg_segument_data_set(dp, 'P', 1);		//DP̃ZOgǉ\
	}
	
	return RET_SUCCESS;
}

int matrixsw_init(void)
{
	//}gbNXXCb`֐
	
	//SW11-SW26̏s܂
	
	// Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	PORT6.PODR.BYTE = 0xF0;		//P64-P67=H
	PORT6.PDR.BYTE = 0xF0;		//P64-P67óAP60-P63͓͂ɐݒ
	
	return RET_SUCCESS;
}

int matrixsw_start(void)
{
	//}gbNXXCb`̒IȓǂݎJn܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	/*
	 * }gbNXXCb`̓ǂݎ(1/4j́ACMT3̃^C~Oōs܂
	 */
	
	g_function_use[IOBOARD_MATRIXSW] = ENABLE;
	
	return RET_SUCCESS;
}

int matrixsw_stop(void)
{
	//}gbNXXCb`̒Iȓǂݎ~܂
	
	//
	//  Ȃ
	
	//߂l
	//  RET_SUCCESS(0)
	
	g_function_use[IOBOARD_MATRIXSW] = DISABLE;
	
	return RET_SUCCESS;
}

int matrixsw_read(unsigned char key)
{
	//}gbNXXCb`̓ǂݏos܂
	
	//
	//  key 0: SW11, 1:SW12, ...15:SW26
	
	//߂l
	//  0 : SWĂ
	//  1 : SWĂȂ
	//  G[ : RET_ERROR(-1)
	
	if (key > 0xf)
	{
		return RET_ERROR;
	}
	
	return (int)g_matrixsw[key];
}
