// lcd_1602.c
//
// SC1602 charactor LCD operation routine
//
// 4bit connection
//

/*
 * @file  lcd_1602.c
 * @brief LCDhCo
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)`(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2018-2022
 */

#include <machine.h>
#include "iodefine.h"
#include "lcd_1602.h"
#include "lcd_1602_RX65.h"

//֐`i[Jj
void lcd_wait_msec(unsigned long msec);
void lcd_wait_s(void);
void lcd_enable_rise(void);
void lcd_enble_fall(void);
void lcd_rs_rise(void);
void lcd_rs_fall(void);
void lcd_db_set(unsigned char c4);
void lcd_port_init (void);

const unsigned char table_h[] = {"0123456789ABCDEF"};

//msec EFCg֐
void lcd_wait_msec(unsigned long msec)
{
	volatile unsigned long lx;
	volatile unsigned short sx;
	
	for(lx=0; lx<msec; lx++)
	{
		for(sx=0; sx<50; sx++) lcd_wait_s();
	}
}

//EFCg֐ (20us)
void lcd_wait_s(void)
{
	volatile unsigned short sx;
	
	for(sx=0; sx<WAIT_20US; sx++) nop();
}

//E(Enable) rise֐
void lcd_enable_rise(void)
{
	LCD_1602_E_PODR = 1;
	nop(); nop(); nop(); nop();
}

//E(Enable) fall֐
void lcd_enable_fall(void)
{
	LCD_1602_E_PODR = 0;
	nop(); nop(); nop(); nop();
}

//RS rise֐
void lcd_rs_rise(void)
{
	LCD_1602_RS_PODR = 1;
	nop(); nop(); nop(); nop();
}

//RS fall֐
void lcd_rs_fall(void)
{
	LCD_1602_RS_PODR = 0;
	nop(); nop(); nop(); nop();
}

//Mo֐
void lcd_db_set (unsigned char c4)
{
	//DBrbg𑗏o֐
	//
	//  unsigned char c4 : 0x0 - 0xf ̃R[h󂯎
	
	LCD_1602_DB7_PODR = (c4 & 0x8) >> 3;
	LCD_1602_DB6_PODR = (c4 & 0x4) >> 2;
	LCD_1602_DB5_PODR = (c4 & 0x2) >> 1;
	LCD_1602_DB4_PODR = c4 & 0x1;
	
}

//R}hM֐
void lcd_cmd(unsigned char c)
{
	//Cӂ̃R}h𑗐M֐
	//
	// unsigned char chara : R[hi8bit)
	
	//RS=0
	lcd_rs_fall();
	
	//upper
	//E->H
	lcd_enable_rise();
	//DB7, DB6, DB5, DB4 = chara upper 4bit
	lcd_db_set(c>>4);
	lcd_wait_s();
	//E->L
	lcd_enable_fall();
	lcd_wait_s();
	
	//lower
	//E->H
	lcd_enable_rise();
	//DB3, DB2, DB1, DB0 = chara lower 4bit
	lcd_db_set(c & 0xf);
	lcd_wait_s();
	//E->L
	lcd_enable_fall();
	lcd_wait_s();
}

//LCD֐
void lcd_init (void)
{
	
	unsigned char i;
	
	lcd_port_init();
	
	lcd_wait_msec(40);	//5V:15ms, 3V:40msEFCgKv
	
	lcd_rs_fall();
	
	//8bit[hؑ DB7=0, DB6=0, DB5=1, DB4=1
	lcd_db_set(0x3);
	lcd_wait_s();
	
	for(i=0; i<3; i++)		//ǂȏԂł8bit[hɐ؂ւłl3JԂœ
	{
		lcd_enable_rise();
		lcd_wait_s();
		lcd_enable_fall();
		lcd_wait_msec(5);	//4.1msȏ
	}
	
	//function set(4bit mode)
	//E->H
	lcd_enable_rise();
	//DB7=0, DB6=0, DB5=1, DB4=0
	lcd_db_set(0x2);
	lcd_wait_s();
	//E->L
	lcd_enable_fall();
	
	lcd_wait_msec(5);
	
	//2line mode
	lcd_cmd(0x28);		//2s\
	
	//b2 D:\ON, b1 C:J[\ON, b0 B:ubNJ[\ON
	lcd_cmd(0x0c);				//ʕ\ON, J[\OFF
	//lcd_cmd(0x0c | 0x01);		//ubNJ[\ON	
	//lcd_cmd(0x0c | 0x02);		//J[\ON
	//lcd_cmd(0x0c | 0x03);		//ubNJ[\{J[\ON
	
	//display->CLEAR
	lcd_cmd(0x01);
	lcd_wait_msec(2);	//1.6msȏ
	
	//entry mode		//b1 I/D 0:fNg, 1:CNg, b0 S:\Vtg
	lcd_cmd(0x06);
}

void lcd_port_init (void)
{
	MPC.PWPR.BIT.B0WI  = 0;
	MPC.PWPR.BIT.PFSWE = 1;
	
	LCD_1602_RS_PFS
	LCD_1602_E_PFS
	LCD_1602_DB4_PFS
	LCD_1602_DB4_PFS
	LCD_1602_DB4_PFS
	LCD_1602_DB4_PFS
	
	MPC.PWPR.BIT.PFSWE = 0;
	
	LCD_1602_RS_PMR
	LCD_1602_E_PMR
	LCD_1602_DB4_PMR
	LCD_1602_DB5_PMR
	LCD_1602_DB6_PMR
	LCD_1602_DB7_PMR
	
	LCD_1602_RS_PODR  = 0;
	LCD_1602_E_PODR   = 0;
	LCD_1602_DB4_PODR = 0;
	LCD_1602_DB5_PODR = 0;
	LCD_1602_DB6_PODR = 0;
	LCD_1602_DB7_PODR = 0;
	
	LCD_1602_RS_PDR  = 1;
	LCD_1602_E_PDR   = 1;
	LCD_1602_DB4_PDR = 1;
	LCD_1602_DB5_PDR = 1;
	LCD_1602_DB6_PDR = 1;
	LCD_1602_DB7_PDR = 1;
}

void lcd_hs1 (void)
{
	//1sڂ1ڂɃJ[\ړ֐
	
	lcd_cmd(0x80);
	lcd_wait_s();
	lcd_wait_s();
	
}

void lcd_hs2 (void)
{
	//2sڂ1ڂɃJ[\ړ֐
	
	lcd_cmd(0xc0);
	lcd_wait_s();
	lcd_wait_s();
	
}

void lcd_clear (void)
{
	//fBXvCNA֐
	
	lcd_cmd(0x01);
	lcd_wait_msec(2);
}

/* LCD\֐ */
void lcd_write_char(unsigned char c)
{
	//Cӂ1\֐
	//
	// unsigned char chara : R[hi8bit)
	
	//RS=1
	lcd_rs_rise();
	
	//upper
	//E->H
	lcd_enable_rise();
	//DB7, DB6, DB5, DB4 = chara upper 4bit
	lcd_db_set(c>>4);
	lcd_wait_s();
	//E->L
	lcd_enable_fall();
	lcd_wait_s();
	
	//lower
	//E->H
	lcd_enable_rise();
	//DB3, DB2, DB1, DB0 = chara lower 4bit
	lcd_db_set(c & 0xf);
	lcd_wait_s();
	//E->L
	lcd_enable_fall();
	lcd_wait_s();
}

void lcd_write_hex(unsigned char c)
{
	//^ꂽhex2(00-ff)ŕ\
	//
	// unsigned char chara : R[hi8bit)
	
	lcd_write_char(table_h[(c >> 4)]);
	lcd_write_char(table_h[(c & 0xf)]);
}

void lcd_write_byte_int( unsigned char num )
{
	unsigned char n[3];
	
	n[0]  = num % 10;
	num  /= 10;
	n[1]  = num % 10;
	num  /= 10;
	n[2]  = num % 10;
	
	if(n[2] != 0)
	{
		lcd_write_char(table_h[n[2]]);
		lcd_write_char(table_h[n[1]]);
	}
	else if(n[1] != 0)
	{
		lcd_write_char(table_h[n[1]]);
	}

	lcd_write_char(table_h[n[0]]);
		
}

void lcd_write_short_int( unsigned short num )
{
	unsigned char n[5];
	
	n[0]  = num % 10;
	num  /= 10;
	n[1]  = num % 10;
	num  /= 10;
	n[2]  = num % 10;
	num  /= 10;
	n[3]  = num % 10;
	num  /= 10;
	n[4]  = num % 10;
	
	if(n[4] != 0)
	{
		lcd_write_char(table_h[n[4]]);
		lcd_write_char(table_h[n[3]]);
		lcd_write_char(table_h[n[2]]);
		lcd_write_char(table_h[n[1]]);
	}
	else if(n[3] != 0)
	{
		lcd_write_char(table_h[n[3]]);
		lcd_write_char(table_h[n[2]]);
		lcd_write_char(table_h[n[1]]);
	}
	else if(n[2] != 0)
	{
		lcd_write_char(table_h[n[2]]);
		lcd_write_char(table_h[n[1]]);
	}
	else if(n[1] != 0)
	{
		lcd_write_char(table_h[n[1]]);
	}

	lcd_write_char(table_h[n[0]]);
		
}

void lcd_write_str(unsigned char *str)
{

	//\֐
	//  
	//    unsigned char *str: \̃|C^i'\0'I[j
	
	while(*str != '\0')
	{
	  lcd_write_char(*str);
	  str++;
	}
}

void lcd_cursor_move(unsigned char lines, unsigned char pos)
{
	//J[\ړ֐
	//  
	//    unsigned char lines: s(1 or 2)
	//    unsigned char pos: J[\ʒu
	
	unsigned char cmd = 0x80;		//J[\ړR}h
	
	if (lines == 2) cmd |= 0x40;	//2sڂ̓J[\ʒu0x40n܂
	
	cmd += pos;
	
	lcd_cmd(cmd);
}
