/*
 * @file  main.c
 * @brief HSBRX65_IO_BOARD TvvOC֐
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)-(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2024
 */

/*----------------------------------------------------------------------
	CN[h
----------------------------------------------------------------------*/
#include	"r_smc_entry.h"

#include	"main.h"
#include	"io_board.h"
#include	"lcd_1602.h"
#include	"sci.h"

/*----------------------------------------------------------------------
	萔`
----------------------------------------------------------------------*/
#define LED7SEG_UPDATE_RATE	(1000)		//7ZOLEDA/DlωȂꍇ́AT1000msɕ\lXV

/*----------------------------------------------------------------------
	O[oϐit@Cj
----------------------------------------------------------------------*/
static volatile int g_function = 0;
static volatile unsigned short g_sw10_toggle = 0;
static volatile unsigned long g_cmt3_wait_counter;
static volatile int g_stepping_motor_direction = 0;		//XebsO[^̉], 0:~, 1:], -1:t]
static volatile unsigned short g_local_adc_val;			//̃^C~OŎ擾A/Dϊl

/*----------------------------------------------------------------------
	֐vg^Cv錾
----------------------------------------------------------------------*/
void main_etc(void);
void wait_ms(unsigned long ms);

//荞݃R[obN֐
void cmt3_callback_etc(void);
void rtc_callback_etc(void);
void adc_callback_etc(void);
void sw8_callback_etc(void);
void sw9_callback_etc(void);
void sw10_callback_etc(void);
void tpu2a_callback_etc(void);
void tpu2b_callback_etc(void);

/*----------------------------------------------------------------------
	֐`
----------------------------------------------------------------------*/
void main_etc(void)
{
	
	//I/O{[h̊e@\ЉTvvO
	
	int current_function = -1;				//݂̓샂[hi_~[j
	
	unsigned char *func_name[6];			//gp@\\
	
	int buzzer_enable = 0;					//uU[炷
	int led8_enable = 0;					//LED8̓_
	int stepping_motor_enable = 0;			//XebsO[^
	unsigned short led7seg_disp;			//7ZOLED\l
	unsigned long led7seg_disp_counter;		//7ZOLED̕\XVJE^
	unsigned short freq;					//uU[̎g
	unsigned long cycle;					//LED8̎
	float duty;								//LED8duty
	unsigned short stepping_motor_rpm;		//XebsO[^̉]
	char buf[20];							//\pobt@
	int i;
	
	//荞݃R[obN֐̊蓖
	cmt3_callback = cmt3_callback_etc;
	rtc_callback = rtc_callback_etc;
	adc_callback = adc_callback_etc;
	sw8_callback = sw8_callback_etc;
	sw9_callback = sw9_callback_etc;
	sw10_callback = sw10_callback_etc;
	tpu2a_callback = tpu2a_callback_etc;
	tpu2b_callback = tpu2b_callback_etc;
	
	//@\iLCD̕\j
	//              1234567890123456
	func_name[0] = "SW0-7 -> LED0-7 ";
	func_name[1] = "MATRIX-SW -> LCD";
	func_name[2] = "VR -> 7SEG LED  ";
	func_name[3] = "BUZZER(VR->FREQ)";
	func_name[4] = "LED8(SW10:CY/DT)";
	func_name[5] = "STEPPING MOTOR  ";
	
	//e평
	push_sw_init();				//vbVXCb`(SW0-SW7)
	intr_push_sw_init(0);		//0:XCb`ۂɔlɂ
	led7seg_init();				//7ZOLED̏
	matrixsw_init();			//}gbNXXCb`̏
	led_init();					//LED(LED0-LED7)
	stepping_motor_init();		//XebsO[^
	lcd_init();					//LCD
	
	//X^[g
	intr_push_sw_start();		//荞݃XCb`Jn
	R_Config_CMT3_Start();		//ADC, 7ZOLED, }gbNXXCb`̃^C}Jn
	adc_start();				//A/DϊJn
	led7seg_start();			//7ZOLED
	matrixsw_start();			//}gbNXXCb`ǂݎ
	
	//J7(USB-miniB)ւ̏\(115,200bps)
	sci_start();
	sci_write_str("\n\nCopyright (C) 2024 HokutoDenshi. All Rights Reserved.\n");
	sci_write_str("HSBRX65-IO-BOARD SAMPLE PROGRAM.\n\n");
	
	sci_write_str("Board function demo.\n");
	
	//LCDւ̏\
	lcd_hs1();
	//             1234567890123456
	lcd_write_str("HSBRX65-IO-BOARD");
	lcd_hs2();
	lcd_write_str("SAMPLE PROGRAM2");
	wait_ms(3000);							//LCD\mF̂3b~
	
	/*
	 * SW8  : @\IUP
	 * SW9  : @\IDOWN
	 * SW10 : @\p[^ݒ
	 */
	
	while(1)
	{
		if (current_function != g_function)
		{
			
			//gp@\ς̂Ŋ̂̂~߂
			if (buzzer_enable == ENABLE)
			{
				buzzer_off();
				buzzer_enable = DISABLE;
			}
			
			if (led8_enable == ENABLE)
			{
				led8_off();
				led8_enable = DISABLE;
			}
			
			if (stepping_motor_enable == ENABLE)
			{
				g_stepping_motor_direction = 0;
				stepping_motor_stop();				//o͂fBXG[u
				stepping_motor_enable= DISABLE;
			}
			
			//gp@\ς^C~OLCD1sڂɋ@\\
			lcd_hs1();
			lcd_write_str(func_name[g_function]);
			
			//LCD2sڂ̕\
			lcd_hs2();
			//             1234567890123456
			lcd_write_str("                ");

			current_function = g_function;	//ݑI𒆂̋@\ۑ
		}
		
		switch (g_function)
		{
			case 0:
				//SW0-7 -> LED0-7A铮
				led_set(~push_sw_read());
				break;
			
			case 1:
				//}gbNXXCb`̓ǂݎ茋ʂLCD2sڂɕ\铮
				//-:ĂȂ
				//*:Ă
				lcd_hs2();
				for (i=0; i<16; i++)
				{
					if (matrixsw_read((unsigned char)i) == 0)
					{
						lcd_write_char('*');	//SWĂꍇ
					}
					else
					{
						lcd_write_char('-');	//SWĂȂꍇ
					}
				}
				break;
				
			case 2:
				//{[(VR, R29)A/Dϊʂ7ZOgLEDɕ\铮
				if ((led7seg_disp >= (adc_val() + 3)) || (led7seg_disp <= (adc_val() - 3)) || (led7seg_disp_counter == 0))
				{
					//l3ȏωꍇ,܂1boߌ͒ɕ\lXV
					led7seg_disp = adc_val();
					led7seg_disp_counter = LED7SEG_UPDATE_RATE;
				}
				else
				{
					
					led7seg_disp_counter--;
				}
				
				led7seg_disp_num(4095 - led7seg_disp, 0);	//0͏_\Ȃ, v->\lƂi0-409510i\j
				wait_ms(1);
				break;
				
			case 3:
				//uU[炷, {[ŉ̍ς
				if (buzzer_enable == DISABLE)
				{
					buzzer_on();
					buzzer_enable = ENABLE;
				}
				//VR->uU[̎gς
				//VR 4095:300Hz, 0:8000Hz
				freq = (4095 - adc_val()) * (8000-300) / 4096 + 300;
				buzzer_freq_set(freq);
				lcd_hs2();
				//1234567890123456
				//FREQ:8000[Hz]   
				lcd_write_str("FREQ:");
				lcd_write_short_int(freq);
				lcd_write_str("[Hz]     ");
				break;
				
			case 4:
				//LED8̓_
				//VR->LED̓_Ŏ̕ύX or LED̓_duty̕ύXiSW10Ő؂芷j
				if (led8_enable == DISABLE)
				{
					led8_on();
					led8_duty_set(0.5f);	//lduty=50%ɂ
					led8_enable = ENABLE;
					g_sw10_toggle = 0;		//SW10͎dutyݒ̐؂ւ
				}
				
				if ((g_sw10_toggle % 2) == 0)
				{
					//VRŎ̕ύX
					cycle = (int)((float)(4095 - g_local_adc_val) * 1.001f) * 65536 / 4096 + 1;	//16bit͈̔͂̎ݒiŒ1jTPU2̎Ŏ擾A/Dlgp
					/*
					 * cycle 1-65535 ͈̔́itXP[jŐݒ肵̂ŁAVRݒl0.1%i4095/4096̕␳jŌvZ
					 */
					if (cycle > 65535) cycle = 65535;
					led8_cycle_set((unsigned short)cycle);
					lcd_hs2();
					//1234567890123456
					//CYCLE:12345     
					lcd_write_str("CYCLE:");
					lcd_write_short_int(cycle);
					lcd_write_str("         ");
				}
				else
				{
					//VRduty̕ύX
					duty = (float)(4095 - adc_val()) * 1.001f / 4096.0f;
					/*
					 * duty 0-1 ͈̔́itXP[jŐݒ肵̂ŁAVRݒl0.1%i4095/4096̕␳jŌvZ
					 * duty1(100%)ɂȂĂA\݂̂ŁAۂ͏o͔g`Ltɂ͂ȂȂ
					 */
					if (duty > 1.0f) duty = 1.0f;
					led8_duty_set(duty);
					float2str(duty * 100.0f, 1, buf);	//dutyl[%]ŏ_ȉ1܂ŕϊ
					lcd_hs2();
					//1234567890123456
					//DUTY:25.1[%]
					lcd_write_str("DUTY:");
					lcd_write_str((unsigned char *)buf);
					lcd_write_str("         ");
				}
				break;
				
			case 5:
				//XebsO[^̋쓮
				//VR->]x & ]iZ^[t߂Œ~, ]ɉAxݒj
				if (stepping_motor_enable == DISABLE)
				{
					led8_on();							//LED8̃^C}(TPU2)ŃXebsO[^̃Xebv֓
					led8_enable = ENABLE;
					stepping_motor_enable = ENABLE;
				}
				//VR t]---------|---------]
				//   4095         2048          0
				

				if (g_adc_result < 2048)
				{
					//]
					g_stepping_motor_direction = 1;
					stepping_motor_rpm = (unsigned short)((float)(2048 - adc_val()) * 8.0f / 2048.0f + 0.5f);	//8Xebvɕϊ, vZʂľܓ
				}
				else
				{
					//t]
					g_stepping_motor_direction = -1;
					stepping_motor_rpm = (unsigned short)((float)(adc_val() - 2048) * 8.0f / 2048.0f + 0.5f);	//8Xebvɕϊ, vZʂľܓ
				}
				
				if (stepping_motor_rpm == 0)
				{
					//VRZ^t߂̎̓XebsO[^𓮂Ȃ
					g_stepping_motor_direction = 0;
					led8_duty_set(0.0f);		//LED8͏
				}
				else
				{
					//stepping_motor_rpm=1͖̎1b1̃Xebvœ
					//XebsO[^TPU2(LED8)ƘAē
					cycle = (unsigned short) (1.0f / (float)(stepping_motor_rpm) / (1.0f / (PCLKB * 1.0e6f) * 1024));
					led8_cycle_set(cycle);
					led8_duty_set(0.1f);		//duty10%iXebsO[^ۂLED8uj
				}
				
				lcd_hs2();
				
				
				if (g_stepping_motor_direction == 0)
				{
					             //12345
					lcd_write_str("STOP ");
				}
				else if (g_stepping_motor_direction == 1)
				{
					lcd_write_str("RIGHT");
				}
				else
				{
					lcd_write_str("LEFT ");
				}
				
				//             6789012
				lcd_write_str(" SPEED=");
				lcd_write_byte_int((unsigned char)stepping_motor_rpm);
				lcd_write_str("     ");
				break;
		}
	}
}

void wait_ms(unsigned long ms)
{
	//EFCg֐
	
	//w肵ԃEFCg|܂
	
	//
	//  ms : ҂[ms]
	
	//߂l
	//  Ȃ
	
	g_cmt3_wait_counter = ms;
	
	while (g_cmt3_wait_counter != 0)
	{
		__nop();
	}
}

/*----------------------------------------------------------------------
	荞݃R[obN֐
----------------------------------------------------------------------*/
void cmt3_callback_etc(void)
{
	//wait_ms()֐JE^
	if (g_cmt3_wait_counter != 0)
	{
		g_cmt3_wait_counter--;
	}
}

void rtc_callback_etc(void){}
void adc_callback_etc(void){}

void sw8_callback_etc(void)
{
	//SW8Ǝ̋@\Ɉړ
	
	g_function++;
	
	if (g_function > 5)
	{
		g_function = 0;		//1Ɛ擪ɖ߂
	}
}

void sw9_callback_etc(void)
{
	//SW9ƑŐ@\Ɉړ
	
	g_function--;
	
	if (g_function < 0)
	{
		g_function = 5;		//1ƍŌɈړ
	}
}

void sw10_callback_etc(void)
{
	//SW10Ƌ@\ɂݒ荀ڂύX
	
	g_sw10_toggle++;
}

void tpu2a_callback_etc(void)
{
	//XebsO[^1Xebv
	
	if (g_stepping_motor_direction != 0)
	{
		stepping_motor_step_move(g_stepping_motor_direction);
	}
	
	//TPU2̎ɘAA/Dϊl
	g_local_adc_val = adc_val();
}

void tpu2b_callback_etc(void){}
