/*
 * @file  main.c
 * @brief HSBRX65_IO_BOARD TvvOC֐
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)-(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2024
 */

/*----------------------------------------------------------------------
	CN[h
----------------------------------------------------------------------*/
#include	"r_smc_entry.h"

#include	"main.h"
#include	"io_board.h"
#include	"lcd_1602.h"
#include	"sci.h"

/*----------------------------------------------------------------------
	萔`
----------------------------------------------------------------------*/
#define BUZZER_PATTERN_CYCLE	(10)
#define TIMER_MAX_SEC			(1000)	//^C}1000b܂ł̎Ԃݒ
#define TIMER_NONE				(0)		//^C}ݒȂ
#define TIMER_VAL_SETTING		(1)		//^C}lݒ蒆
#define TIMER_COUNT				(2)		//^C}JEg
#define TIMER_ALARM_1			(1)		//^C}A[iss@ssj
#define TIMER_ALARM_2			(2)		//^C}A[iAj
#define TIMER_ALARM_1_TIME		(30)	//^C}30bŘAɈڍs

/*----------------------------------------------------------------------
	\
----------------------------------------------------------------------*/

/*----------------------------------------------------------------------
	O[oϐit@Cj
----------------------------------------------------------------------*/
static volatile int g_lcd_update = 1;			//LCD2sڂ̍XV^C~Oi͖ōXVj
static volatile int g_buzzer_flow = 0;			//0:TPU2荞݂ŉȂ, 1:p^[Ŗ炷, 2:dutyŖ炷
static volatile unsigned char g_buzzer_pattern[BUZZER_PATTERN_CYCLE];
static volatile int g_sw8_push = 0;
static volatile int g_sw9_push = 0;
static volatile int g_sw10_push = 0;
//j
static unsigned char *dayw[7] = {"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"}; 

static volatile int g_timer_operation = 0;		//^C}ݒ, 0:ݒȂ, 1:^C}lύX, 2:^C}JEg, 3:A[(1), 4:A[(2) 
static volatile int g_timer_val = 0;			//^C}ݒl

/*----------------------------------------------------------------------
	֐vg^Cv錾
----------------------------------------------------------------------*/
void main_timer(void);
void alarm_on(int level);
void alarm_off(void);
void calender_set(void);
void calender_set_lcd_disp(int process, int *modify);
int day_of_week(int y, int m, int d);
void led7seg_off(void);

//荞݃R[obN֐
void cmt3_callback_timer(void);
void rtc_callback_timer(void);
void adc_callback_timer(void);
void sw8_callback_timer(void);
void sw9_callback_timer(void);
void sw10_callback_timer(void);
void tpu2a_callback_timer(void);
void tpu2b_callback_timer(void);

/*----------------------------------------------------------------------
	֐`
----------------------------------------------------------------------*/
void main_timer(void)
{
	//I/O{[hgpă^C}sTvvO
	
	//J_\l
	rtc_calendarcounter_value_t disp;
	
	unsigned char day_cnt = 0x00;		//tςLCD1sڂXV, l݂͑ȂtƂ
	int timer_alarm = 0;				//A[̏ 0:~, 1:, 2:A
	int vr_invalid = 0;					//A[̎Ԑݒ 0:VRŒ, 1:SW9, SW10Ŕ
	int current_adc_val;				//A/Dϊlۑ, 傫ςꍇVRēxL
	
	//荞݃R[obN֐̊蓖
	cmt3_callback = cmt3_callback_timer;
	rtc_callback = rtc_callback_timer;
	adc_callback = adc_callback_timer;
	sw8_callback = sw8_callback_timer;
	sw9_callback = sw9_callback_timer;
	sw10_callback = sw10_callback_timer;
	tpu2a_callback = tpu2a_callback_timer;
	tpu2b_callback = tpu2b_callback_timer;
	
	//e평
	push_sw_init();				//vbVXCb`(SW0-SW7)
	intr_push_sw_init(0);		//0:XCb`ۂɔlɂ
	led7seg_init();				//7ZOLED̏
	matrixsw_init();			//}gbNXXCb`̏
	led_init();					//LED(LED0-LED7)
	stepping_motor_init();		//XebsO[^
	lcd_init();					//LCD
	
	//X^[g
	intr_push_sw_start();		//荞݃XCb`Jn
	R_Config_CMT3_Start();		//ADC, 7ZOLED, }gbNXXCb`̃^C}Jn
	R_Config_RTC_Start();		//A^CNbNJn
	adc_start();				//A/DϊJn
	led7seg_start();			//7ZOLED
	matrixsw_start();			//}gbNXXCb`ǂݎ

	//J7(USB-miniB)ւ̏\(115,200bps)
	sci_start();
	sci_write_str("\n\nCopyright (C) 2024 HokutoDenshi. All Rights Reserved.\n");
	sci_write_str("HSBRX65-IO-BOARD TIMER SAMPLE PROGRAM.\n\n");
	
	/*
	 * SW8  : J_ivjύX, NԁbݒI
	 * SW9  : t⎞Ԃ߂
	 * SW10 : t⎞Ԃi߂
	 */
	 
	 /*
	  * SW0 : ^C}Zbg
	  * SW1 : ^C}X^[g
	  * SW7 : ^C}LZ
	  * SW0-SW7 : A[~
	  */
	
	while(1)
	{	
		//LCD\XV
		if (g_lcd_update == 1)
		{
			R_Config_RTC_Get_CalendarCounterValue(&disp);
			
			//2s
			//1234567890123456
			//20:25:30
			lcd_hs2();
			lcd_write_hex(disp.rhrcnt);
			lcd_write_char(':');
			lcd_write_hex(disp.rmincnt);
			lcd_write_char(':');
			lcd_write_hex(disp.rseccnt);
			
			if (disp.rdaycnt != day_cnt)	//tς^C~O
			{
				//1s
				//1234567890123456
				//2024/12/31 (FRY)
				lcd_hs1();
				lcd_write_str("20");
				lcd_write_hex(disp.ryrcnt);
				lcd_write_char('/');
				lcd_write_hex(disp.rmoncnt);
				lcd_write_char('/');
				lcd_write_hex(disp.rdaycnt);
				lcd_write_str(" (");
				lcd_write_str(dayw[disp.rwkcnt]);
				lcd_write_str(")     ");
				
				day_cnt = disp.rdaycnt;
			}
			
			g_lcd_update = 0;
		}
		
		if (g_sw8_push == 1)
		{
			//SW8: J_ݒs
			g_sw8_push = 0;
			calender_set();
		}
		
		//^C}
		switch (g_timer_operation)
		{
			case TIMER_NONE:
			
				led_set(0x1);	//A[ݒJnSW0->LED0_
				
				if ((push_sw_read() & 0x1) == 0x0)
				{
					//SW0ꂽ̂ŃA[ݒ胂[hɈڍs
					g_timer_operation = TIMER_VAL_SETTING;
					vr_invalid = 0;			//VRL
				}
				break;
				
			case TIMER_VAL_SETTING:
			
				led_set(0x2);	//^C}X^[gSW1->LED1_
				
				if ((adc_val() < (current_adc_val - 100)) || (adc_val() > (current_adc_val + 100)))
				{
					//VR񂳂ꂽ̂ŁiVR𖳌傫ϓ̂ŁjVR̓ǂݎLƂ
					vr_invalid = 0;
				}
				
				if (vr_invalid == 0)
				{
					g_timer_val = (int)((float)(4095 - adc_val()) * 1.002f) * TIMER_MAX_SEC / 4096 + 1; //{[ɂ 1 - TIMER_MAX_SEC ͈̔͂Őݒ, A/Dl4095܂ŒBȂĂ2%Zčől܂ŒBlɂ
				}
				
				if (g_sw10_push == 1)
				{
					//SW10: i^C}Ԃ1b₷j
					g_timer_val++;
					vr_invalid = 1;					//VR𖳌
					current_adc_val = adc_val();	//݂VR̓ǂݎlۑ
					g_sw10_push = 0;
					
				}
				
				if (g_sw9_push == 1)
				{
					//SW9: i^C}Ԃ1b炷j
					g_timer_val--;
					vr_invalid = 1;					//VR𖳌
					current_adc_val = adc_val();	//݂VR̓ǂݎlۑ
					g_sw9_push = 0;
				}
				
				//g_timer_val̗L͈
				if (g_timer_val > TIMER_MAX_SEC)
				{
					g_timer_val = TIMER_MAX_SEC;
				}
				else if (g_timer_val < 1)
				{
					g_timer_val = 1;
				}
				
				led7seg_disp_num(g_timer_val, 0);	//7ZOLEDɃ^C}l\
				if ((push_sw_read() & 0x2) == 0x0)
				{
					//SW1ꂽ̂Ń^C}X^[g
					g_timer_operation = TIMER_COUNT;
					led_set(0x0);	//LED͏
				}
				break;
				
			case TIMER_COUNT:
				
				if (g_timer_val > 0)
				{
					//JEg
					led7seg_disp_num(g_timer_val, 0);	//7ZOLEDɃ^C}l\
				}
				else
				{
					//JEgIiA[j
					led7seg_disp_num(0, 0);				//JEgI0\
					
					if (timer_alarm == 0)
					{
						alarm_on(TIMER_ALARM_1);
						timer_alarm = TIMER_ALARM_1;
						led_set(0xff);						//LED0-LED7I
					}
					else if ((timer_alarm == TIMER_ALARM_1) && ((g_timer_val * -1) > TIMER_ALARM_1_TIME))	//JEg0ɂȂAg_timer_val ͌Z
					{
						alarm_on(TIMER_ALARM_2);
						timer_alarm = TIMER_ALARM_2;
					}
					
					if (push_sw_read() != 0xff)
					{
						//JEgIiA[jɁASW0-SW7̂ꂩ̃XCb`ƃA[~܂
						alarm_off();
						led_set(0);							//LED0-LED7It
						led7seg_off();						//7ZOLEDIt
						g_timer_operation = TIMER_NONE;
						timer_alarm = 0;
						g_timer_val = 0;
					}
				}
				break;
		}
		
		if ((push_sw_read() & 0x80) == 0x0)
		{
			//SW7ꂽꍇ̓^C}LZ
			alarm_off();
			led_set(0);							//LED0-LED7It
			led7seg_off();						//7ZOLEDIt
			g_timer_operation = TIMER_NONE;
			timer_alarm = 0;
			g_timer_val = 0;
		}
		
		__nop();
	}
}

void alarm_on(int level)
{
	//A[炷֐
	
	//
	//  level
	//    0 : AŃs[炷
	//    1 : s[@s[... s[ s[...̌JԂ
	//    2 : sssssšJԂ
	
	//߂l
	//  Ȃ
	
	int i;
	
	buzzer_freq_set(4000);	//uU[̍4,000HzƂ
	
	switch (level)
	{
		case 0:
			buzzer_on();
			break;
			
		case 1:
			for (i=0; i<10; i++) g_buzzer_pattern[i] = 0;
			g_buzzer_pattern[0] = 1;
			g_buzzer_pattern[2] = 1;
			//oxoxxxxxxx̌JԂ
			g_buzzer_flow = 1;		//p^[Ŗ炷
			led8_cycle_set(10000);	//p^[̏ꍇduty͊֌WȂ
			led8_duty_set(0.02f);	//uU[炷^C~OLEDu_
			led8_on();
			break;
			
		case 2:
			g_buzzer_flow = 2;		//dutyŖ炷
			led8_cycle_set(10000);
			led8_duty_set(0.5f);	//uU[炷duty
			led8_on();
			break;
	}
			
}

void alarm_off(void)
{
	//A[~߂֐
	
	//
	//  Ȃ
	
	//߂l
	//  Ȃ
	
	buzzer_off();
	led8_off();
	
}

void calender_set(void)
{
	//J_ݒ֐
	
	//
	//  Ȃ
	
	//߂l
	//  Ȃ
	
	rtc_calendarcounter_value_t cal;
	int process = 0;	//0:N̕ύX, 1:̕ύX, 2:̕ύX, 3:Ԃ̕ύX, 4:̕ύX, 5:b̕ύX, 6:{֐𔲂
	
	int year_desision = 0;	//N̊m
	int month_desision = 0;	//̊m
	
	int modify[6];
	int modify_max[6] = {2099, 12, 31, 23, 59, 59};
	int modify_min[6] = {2020, 1, 1, 0, 0, 0};
	
	//Ƃ̓
	unsigned char month_days[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	R_Config_RTC_Get_CalendarCounterValue(&cal);
	
	modify[0] = (cal.ryrcnt & 0x0F) + (((cal.ryrcnt & 0xF0) >> 4) * 10) + 2000;
	modify[1] = (cal.rmoncnt & 0x0F) + (((cal.rmoncnt & 0xF0) >> 4) * 10);
	modify[2] = (cal.rdaycnt & 0x0F) + (((cal.rdaycnt & 0xF0) >> 4) * 10);
	
	modify[3] = (cal.rhrcnt & 0x0F) + (((cal.rhrcnt & 0xF0) >> 4) * 10);
	modify[4] = (cal.rmincnt & 0x0F) + (((cal.rmincnt & 0xF0) >> 4) * 10);
	modify[5] = (cal.rseccnt & 0x0F) + (((cal.rseccnt & 0xF0) >> 4) * 10);
	
	calender_set_lcd_disp(process, modify);	//\XV
	
	//SW9, SW10͉ς݂̏ꍇłLZĂ
	g_sw9_push = 0;
	g_sw10_push = 0;
	
	while (1)
	{
		if (g_sw8_push == 1)
		{
			//SW8 : ̐ݒ荀ڂ֐i߂, ݒI
			g_sw8_push = 0;
			process++;
			
			calender_set_lcd_disp(process, modify);	//\XV
		}
		
		if (g_sw10_push == 1)
		{
			//SW10 : ݒ荀ڒl+1
			g_sw10_push = 0;
			modify[process] += 1;
			if (modify[process] > modify_max[process])
			{
				modify[process] = modify_min[process];
			}
			
			calender_set_lcd_disp(process, modify);	//\XV
		}
		
		if (g_sw9_push == 1)
		{
			//SW9 : ݒ荀ڒl-1
			g_sw9_push = 0;
			modify[process] -= 1;
			if (modify[process] < modify_min[process])
			{
				modify[process] = modify_max[process];
			}
			
			calender_set_lcd_disp(process, modify);	//\XV
		}
		
		if ((process == 1) && (year_desision == 0))
		{
			//Nm肵_ł邤Nm肳
			
			if ((modify[0] % 4) == 0)
			{
				//2020-2099̊Ԃɂ́A100Ŋ؂, 400Ŋ؂OȂ
				month_days[1] = 29;
			}
			year_desision = 1;
		}
		
		if ((process == 2) && (month_desision == 0))
		{
			//m肵_Ō̓m肳
			modify_max[2] = month_days[modify[1] - 1];
			
			month_desision = 1;
		}
		
		if (process >= 6) break;	//ݒI

	}
	
	lcd_cmd(0x0c);	//J[\OFF
	
	cal.ryrcnt = (((modify[0] - 2000) / 10) << 4) + ((modify[0] - 2000) % 10);
	cal.rmoncnt = ((modify[1] / 10) << 4) + (modify[1] % 10);
	cal.rdaycnt = ((modify[2] / 10) << 4) + (modify[2] % 10);
	cal.rwkcnt = (unsigned char)day_of_week(modify[0], modify[1], modify[2]);
	cal.rhrcnt = ((modify[3] / 10) << 4) + (modify[3] % 10);
	cal.rmincnt = ((modify[4] / 10) << 4) + (modify[4] % 10);
	cal.rseccnt = ((modify[5] / 10) << 4) + (modify[5] % 10);
	
	//RTCɎԐݒ
	RTC.RSECCNT.BYTE = cal.rseccnt;
    RTC.RMINCNT.BYTE = cal.rmincnt;
    RTC.RHRCNT.BYTE = cal.rhrcnt;
    RTC.RWKCNT.BYTE = cal.rwkcnt;
    RTC.RDAYCNT.BYTE = cal.rdaycnt;
    RTC.RMONCNT.BYTE = cal.rmoncnt;
    RTC.RYRCNT.WORD = cal.ryrcnt;
}

void calender_set_lcd_disp(int process, int *modify)
{
	//J_ݒ蒆LCD\֐
	
	//
	//  process : ǂ̍ڂݒ蒆
	//  *modify : XV̒l
	
	//߂l
	//  Ȃ
	
	rtc_calendarcounter_value_t cal;

	cal.ryrcnt = (((modify[0] - 2000) / 10) << 4) + ((modify[0] - 2000) % 10);
	cal.rmoncnt = ((modify[1] / 10) << 4) + (modify[1] % 10);
	cal.rdaycnt = ((modify[2] / 10) << 4) + (modify[2] % 10);
	cal.rwkcnt = (unsigned char)day_of_week(modify[0], modify[1], modify[2]);
	cal.rhrcnt = ((modify[3] / 10) << 4) + (modify[3] % 10);
	cal.rmincnt = ((modify[4] / 10) << 4) + (modify[4] % 10);
	cal.rseccnt = ((modify[5] / 10) << 4) + (modify[5] % 10);
	
	//1s
	//1234567890123456
	//2024/12/31 (FRY)
	lcd_hs1();
	lcd_write_str("20");
	lcd_write_hex(cal.ryrcnt);
	lcd_write_char('/');
	lcd_write_hex(cal.rmoncnt);
	lcd_write_char('/');
	lcd_write_hex(cal.rdaycnt);
	lcd_write_str(" (");
	lcd_write_str(dayw[cal.rwkcnt]);
	lcd_write_str(")     ");
	
	//2s
	//1234567890123456
	//20:25:30
	lcd_hs2();
	lcd_write_hex(cal.rhrcnt);
	lcd_write_char(':');
	lcd_write_hex(cal.rmincnt);
	lcd_write_char(':');
	lcd_write_hex(cal.rseccnt);

	//0123456789012345
	//2024/12/20
	//17:50:31
	switch (process)
	{
		case 0:	//N̕ҏW
			lcd_cursor_move(1, 3);
			break;
	
		case 1:	//̕ҏW
			lcd_cursor_move(1, 6);
			break;
			
		case 2:	//̕ҏW
			lcd_cursor_move(1, 9);
			break;
		
		case 3:	//Ԃ̕ҏW
			lcd_cursor_move(2, 1);
			break;
		
		case 4:	//̕ҏW
			lcd_cursor_move(2, 4);
			break;
		
		case 5:	//b̕ҏW
			lcd_cursor_move(2, 7);
			break;
	}
	lcd_cmd(0x0f);	//J[\ON, J[\_
}

int day_of_week(int y, int m, int d)
{
	//j߂֐
	
	//
	//  y : N
	//  m : 
	//  d : t
	
	//߂l
	// 0 : j
	// 1 : j
	// ...
	// 6 : yj
	
	if (m < 3)
	{
		y--;
		m += 12;
	}
	
	return (365 * y + y / 4 - y / 100 + y / 400 + 306 * (m + 1) / 10 + d - 428) % 7;
}

void led7seg_off(void)
{
	//7ZOLEDIt֐
	
	//
	//  Ȃ
	
	//߂l
	//  Ȃ
	
	int i;
	
	for (i=1; i<=4; i++)
	{
		//eZOgOFF
		led7seg_segument_data_set(i, 'A', 0);
		led7seg_segument_data_set(i, 'B', 0);
		led7seg_segument_data_set(i, 'C', 0);
		led7seg_segument_data_set(i, 'D', 0);
		led7seg_segument_data_set(i, 'E', 0);
		led7seg_segument_data_set(i, 'F', 0);
		led7seg_segument_data_set(i, 'G', 0);
		led7seg_segument_data_set(i, 'P', 0);
	}
}

/*----------------------------------------------------------------------
	荞݃R[obN֐
----------------------------------------------------------------------*/
void cmt3_callback_timer(void)
{
}

void rtc_callback_timer(void)
{
	//RTC荞݂̃^C~OLCD\XV
	
	g_lcd_update = 1;	//bPʂLCD2sڂXV
	
	if (g_timer_operation == TIMER_COUNT)
	{
		//^C}JEg̓^C}lZ
		g_timer_val--;
	}
}

void adc_callback_timer(void)
{
}

void sw8_callback_timer(void)
{
	g_sw8_push = 1;
}

void sw9_callback_timer(void)
{
	g_sw9_push = 1;
}

void sw10_callback_timer(void)
{
	g_sw10_push = 1;
}

void tpu2a_callback_timer(void)
{
	static int counter = 0;
	
	//uU[
	if (g_buzzer_flow == 1)
	{
		//s[s[..s[s[..ȂǓ̃p^[ŃuU[炷
		if (g_buzzer_pattern[counter++] == 1)
		{
			buzzer_on();
			led_set(0xff);	//LED0-LED7S_
		}
		else
		{
			buzzer_off();
			led_set(0x0);	//LED0-LED7
		}
		if (counter >= BUZZER_PATTERN_CYCLE) counter = 0;
	}
	else if (g_buzzer_flow == 2)
	{
		//ssss..Ȃǂ̘AŃuU[炷
		buzzer_off();
		led_set(0xff);	//LED0-LED7S_
	}
}

void tpu2b_callback_timer(void)
{
	//uU[
	if (g_buzzer_flow == 2)
	{
		buzzer_on();
	}
}