/**
 * @file  sci.h
 * @brief SCIhCowb_
 *
 * @version: 1.9 2024/10/17, $Id: $
 *
 * {\tgEFA̒쌠͍쐬ł()kldqL̂ƂA
 * ()kldq́Aȉ (1)-(3) ̏𖞂ꍇɌA
 * {\tgEFAi{\tgEFAς̂܂ށBȉj
 * gpEEρEĔzziȉApƌĂԁj邱Ƃ𖳏ŋB
 *
 * (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́AL̒
 *	   \A̗pÂ܂܂̌`Ń\[XR[hɊ܂܂
 *	   邱ƁB
 * (2) {\tgEFÄꕔ܂͑SĂ𖳒fœ]ڂ邱Ƃ֎~
 *	   ƂBGȂǂ֏ЉE^̏ꍇ()kldqɘA肢܂B
 * (3) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *	   A()kldq͈؂̐ӔC𕉂Ȃ̂ƂB
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2021-2024
 */

#ifndef SCI_H__
#define SCI_H__

/* [UőI鍀(*n)ɊւẮAreadme.txtQƂĂ */

/*----------------------------------------------------------------------
	}CRʁiʃt@CŒ`j(*1)
----------------------------------------------------------------------*/

//#include "../mcu_type/mcu_type.h"		//ʃt@C̒`ǂݍ, ʃt@CŐݒ肵Ȃꍇ̓RgAEg

/*----------------------------------------------------------------------
	}CRʁiꂩ1Ij(*1')
----------------------------------------------------------------------*/

#ifndef MCU_TYPE_DEFINED	//Œ`ς݂̏ꍇ́Ał̐ݒXLbv

//L5ނ̓1L

#define MCU_TYPE_RX
//#define MCU_TYPE_RL78
//#define MCU_TYPE_RA
//#define MCU_TYPE_RH850
//#define MCU_TYPE_RISC_V

#endif

/*----------------------------------------------------------------------
	RL78̏ꍇ X}[gRtBO[^, R[ĥǂ炩 iǂ炩Ij(*2)
----------------------------------------------------------------------*/

#if defined(MCU_TYPE_RL78)
#define RL78_SMART_CONFIGURATOR			//X}[gRtBO[^iRL78/G2xȍ~j
//#define RL78_CODE_GENERATION			//R[h
#endif

/*----------------------------------------------------------------------
    RȀꍇ SCI, SCI_B̂ǂ炩 iǂ炩Ij(*2')
----------------------------------------------------------------------*/

#if defined(MCU_TYPE_RA)
#define RA_SCI							//ʏSCI
//#define RA_SCI_B						//SCI_B
#endif

/*----------------------------------------------------------------------
	CN[h(*3)
----------------------------------------------------------------------*/

#if defined(MCU_TYPE_RX)

#include	"r_smc_entry.h"

#elif defined(MCU_TYPE_RL78)

#ifdef RL78_SMART_CONFIGURATOR			//RL78/G23̃X}[gRtBO[^ł͗L
#include	"r_smc_entry.h"	
#endif

#ifdef RL78_CODE_GENERATION				//RL78R[hgꍇL
#include	"r_cg_macrodriver.h"
#include	"r_cg_serial.h"				//}CRɂ
//#include	"r_cg_sau.h"				//ǂ炩I
#endif

#elif defined(MCU_TYPE_RA)

#include	"hal_data.h"

#elif defined(MCU_TYPE_RH850)

#include	"iodefine.h"
#include	"r_cg_macrodriver.h"
#include	"Config_UART1.h"			//CHw

#elif defined(MCU_TYPE_RISC_V)

#include	"r_smc_entry.h"

#endif

/*----------------------------------------------------------------------
	}CRˑ`, SCI`l`(*4)
----------------------------------------------------------------------*/

#if defined(MCU_TYPE_RX)

#define INTERRUPT_DISABLE	clrpsw_i()
#define INTERRUPT_ENABLE	setpsw_i()

#define NOP_MCU_DEP			__nop()

#define SCI_START			(void)R_Config_SCI5_Start()
#define SCI_STOP			(void)R_Config_SCI5_Stop()
#define SCI_SEND(a,b) 		(void)R_Config_SCI5_Serial_Send(a,b)
#define SCI_RECEIVE(a,b) 	(void)R_Config_SCI5_Serial_Receive(a,b)

#elif defined(MCU_TYPE_RL78)

#define INTERRUPT_DISABLE	DI()
#define INTERRUPT_ENABLE	EI()

#define NOP_MCU_DEP			__nop()

#ifdef RL78_SMART_CONFIGURATOR
#define SCI_START			(void)R_Config_UART0_Start()
#define SCI_STOP			(void)R_Config_UART0_Stop()
#define SCI_SEND(a,b) 		(void)R_Config_UART0_Send(a,b)
#define SCI_RECEIVE(a,b) 	(void)R_Config_UART0_Receive(a,b)
#endif

#ifdef RL78_CODE_GENERATION
#define SCI_START			(void)R_UART0_Start()
#define SCI_STOP			(void)R_UART0_Stop()
#define SCI_SEND(a,b) 		(void)R_UART0_Send(a,b)
#define SCI_RECEIVE(a,b) 	(void)R_UART0_Receive(a,b)
#endif

#elif defined(MCU_TYPE_RA)

#define INTERRUPT_DISABLE	__disable_irq()
#define INTERRUPT_ENABLE	__enable_irq()

#define NOP_MCU_DEP			__NOP()

#ifdef RA_SCI
#define SCI_START			(void)R_SCI_UART_Open(&g_uart9_ctrl, &g_uart9_cfg)
#define SCI_STOP			(void)R_SCI_UART_Close(&g_uart9_ctrl)
#define SCI_SEND(a,b) 		(void)R_SCI_UART_Write(&g_uart9_ctrl,a,b)
#define SCI_RECEIVE(a,b) 	(void)R_SCI_UART_Read(&g_uart9_ctrl,a,b)
#endif

#ifdef RA_SCI_B
#define SCI_START           (void)R_SCI_B_UART_Open(&g_uart9_ctrl, &g_uart9_cfg)
#define SCI_STOP            (void)R_SCI_B_UART_Close(&g_uart9_ctrl)
#define SCI_SEND(a,b)       (void)R_SCI_B_UART_Write(&g_uart9_ctrl,a,b)
#define SCI_RECEIVE(a,b)    (void)R_SCI_B_UART_Read(&g_uart9_ctrl,a,b)
#endif

#elif defined(MCU_TYPE_RH850)

#define INTERRUPT_DISABLE	DI()
#define INTERRUPT_ENABLE	EI()

#define NOP_MCU_DEP			__nop()

#define SCI_START			(void)R_Config_UART1_Start()
#define SCI_STOP			(void)R_Config_UART1_Stop()
#define SCI_SEND(a,b)		R_Config_UART1_Send(a,b)			//M֐̂ݖ߂lgp
#define SCI_RECEIVE(a,b)	(void)R_Config_UART1_Receive(a,b)

#elif defined(MCU_TYPE_RISC_V)

//RISC-Vł͑Ŝ̊荞(mstatus.mie)𑀍삷鎖͂AUART̑M荞݂݈̂ꎞIɑ삷

//UART0(SAU0_ENDI0)̏ꍇŁA SAU0_ENDI0IESLR8 ɊtꂽꍇA R_CLIC->clicintie27_b.IE
//IESLR0 -> R_CLIC->clicintie19_b.IE
//...
//IESLR8 -> R_CLIC->clicintie27_b.IE
//gp鑗M荞݂gpꂽ IESLR ɉāA"27" ͕̕ύXv

#define INTERRUPT_DISABLE	R_CLIC->clicintie27_b.IE=0
#define INTERRUPT_ENABLE	R_CLIC->clicintie27_b.IE=1

#define NOP_MCU_DEP			NOP()

#define SCI_START			(void)R_Config_UART0_Start()
#define SCI_STOP			(void)R_Config_UART0_Stop()
#define SCI_SEND(a,b) 		(void)R_Config_UART0_Send(a,b)
#define SCI_RECEIVE(a,b) 	(void)R_Config_UART0_Receive(a,b)

#endif

/*----------------------------------------------------------------------
	萔`(*5)
----------------------------------------------------------------------*/
#define FLAG_SET	1
#define FLAG_CLEAR	0

#define SCI_RECEIVE_DATA_EMPTY		0xFFFF	//Mf[^Ȃꍇ̕ԋpl
#define SCI_SEND_BUF_OVERFLOW		0x80	//Xe[^XFMobt@ꂽꍇ
#define SCI_RECEIVE_BUF_OVERFLOW	0x40	//Xe[^XFMobt@ꂽꍇ
#define SCI_RECEIVE_ERROR			0x08	//Xe[^XFMG[ꍇ
#define SCI_RECEIVE_PARITY_ERROR	0x04	//Xe[^XFMG[ipeBjꍇ peBLɂĂȂ̂ŔȂ͂
#define SCI_RECEIVE_FRAMING_ERROR	0x02	//Xe[^XFMG[it[~Ojꍇ RAłG[ʂEĂȂ
#define SCI_RECEIVE_OVERRUN_ERROR	0x01	//Xe[^XFMG[iI[o)ꍇ RAłG[ʂEĂȂ

#define SCI_SEND_BUF_SIZE			1024	//Mobt@F1024 x 2y[W = 2048bytes𑗐Mobt@ƂĎgp
#define SCI_RECV_BUF_SIZE 			16		//Mobt@F16bytesiL[{[h̃R}h͂zj
/*
RL78G10RAM̏}CRł́AftHg(2kB)́ARAMeʂI[oĂ܂̂
SCI_SEND_BUF_SIZE ̒l𒲐Ă
*/

#define SCI_USE_FLOAT						//_̊֐gp
/*
RL78G10ROM̏}CRł͕KvɉăRgAEgĂ
iRL78ł́ARgAEg鎖4kBxROMʂ܂j
*/

#define SCI_USE_TX							//M@\gp
#define SCI_USE_RX							//M@\gp
/*
MƎM̕ЕgpȂꍇ́AgpȂRgAEgĂ
*/

/*----------------------------------------------------------------------
	OQƁi֐j
----------------------------------------------------------------------*/
extern void sci_start(void);
extern void sci_stop(void);
#ifdef SCI_USE_TX
extern void sci_write_char(unsigned char c);
extern void sci_write_uint8_hex(unsigned char c);
extern void sci_write_uint16_hex(unsigned short s);
extern void sci_write_uint32_hex(unsigned long l);
extern void sci_write_uint8(unsigned char num);
extern void sci_write_uint16(unsigned short num);
extern void sci_write_uint32(unsigned long num);
extern void sci_write_int8(char num);
extern void sci_write_int16(short num);
extern void sci_write_int32(long num);
extern void sci_write_str(const char *str);
extern void sci_write_flush(void);
#endif
#ifdef SCI_USE_RX
extern unsigned short sci_read_char(unsigned char *c);
extern unsigned short sci_read_str(char *str, unsigned short size);
extern unsigned short sci_read_data_size(void);
extern void sci_read_buf_clear(void);
#endif
#ifdef SCI_USE_FLOAT
extern int float2str(float value, int num, char *str);
extern int float2str_eformat(float value, int num, char *str);
extern int double2str(double value, int num, char *str);
extern int double2str_eformat(double value, int num, char *str);
#endif

/*----------------------------------------------------------------------
	荞݊֐Ă΂֐
----------------------------------------------------------------------*/
#ifdef SCI_USE_TX
extern void intr_sci_send_end(void);
#endif
#ifdef SCI_USE_RX
extern void intr_sci_receive_end(void);
extern void intr_sci_receive_error(void);
#endif

/*
 RX, RL78, RH850, RISC_V̏ꍇAc[Ő R[h( Config_????_user.c / r_cg_????_user.c )
 Ɉȉ̋Lڂǉ Ăiڂ readme.txt QƁj

EIncludeśu/ * Start user code for include.vƁu/ * End user code.v̊Ԃ

#include "sci.h"

 LڂB

EMɌĂяo( ~transmitend(), ~sendend() )ɋLځiM@\gpj

intr_sci_send_end();

EMɌĂяo( ~receiveend() )ɋLځiM@\gpj

intr_sci_receive_end();

EMG[ɌĂяo( ~receiveerror(), ~error() )ɋLځiM@\gpj

intr_sci_receive_error();

*/

/*----------------------------------------------------------------------
	OQƁiϐj
----------------------------------------------------------------------*/
#ifdef SCI_USE_TX
extern unsigned char g_sci_send_buf[2][SCI_SEND_BUF_SIZE];
#endif
#ifdef SCI_USE_RX
extern unsigned char g_sci_recv_buf[SCI_RECV_BUF_SIZE];
#endif
#ifdef SCI_USE_TX
extern volatile unsigned short g_sci_send_buf_index[2];
#endif
#ifdef SCI_USE_TX
extern volatile unsigned char g_sci_send_buf_page_index; 
extern volatile unsigned char g_sci_send_flag;
extern volatile unsigned char g_sci_send_nowait_flag;
#endif
#ifdef SCI_USE_RX
extern volatile unsigned short g_sci_recv_buf_index1 ;
extern volatile unsigned short g_sci_recv_buf_index2 ;
extern unsigned char g_sci_recv_data;
#endif
extern volatile unsigned char g_sci_status;
extern volatile unsigned char g_sci_start;

#endif
/* End of File */
