/*
 * @file  io_board.h
 * @brief HSBRX65_IO_BOARDドライバヘッダ
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)-(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *	   権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *	   いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *	   とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *	   からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2024
 */

#ifndef IO_BOARD_H__
#define IO_BOARD_H__

/*----------------------------------------------------------------------
    定数定義
----------------------------------------------------------------------*/
//戻り値
#define RET_SUCCESS					(0)		//成功
#define RET_ERROR					(-1)	//エラー

//有効・無効
#define ENABLE						(1)
#define DISABLE						(0)

//CMT3で処理される各種機能
#define IOBOARD_ADC					(0)
#define IOBOARD_LED7SEG				(1)
#define IOBOARD_MATRIXSW			(2)

#define IOBOARD_CMT3_FUNCTION_NUM	(3)		//CMT3で"ADC", "7セグLED", "マトリックススイッチ"の3種類の機能を処理

//ADCの移動平均
#define IOBOARD_ADC_AVERAGE_NUM		(16)	//16データの移動平均を取る

//7セグLED
#define IOBOARD_LED7SEG_COM			(4)		//COM信号4本
#define IOBOARD_LED7SEG_COM1		(0)
#define IOBOARD_LED7SEG_COM2		(1)
#define IOBOARD_LED7SEG_COM3		(2)
#define IOBOARD_LED7SEG_COM4		(3)

//マトリックススイッチ
#define IOBOARD_MATRIXSW_NUM		(16)
#define IOBOARD_SW11				(0)
#define IOBOARD_SW12				(1)
#define IOBOARD_SW13				(2)
#define IOBOARD_SW14				(3)
#define IOBOARD_SW15				(4)
#define IOBOARD_SW16				(5)
#define IOBOARD_SW17				(6)
#define IOBOARD_SW18				(7)
#define IOBOARD_SW19				(8)
#define IOBOARD_SW20				(9)
#define IOBOARD_SW21				(10)
#define IOBOARD_SW22				(11)
#define IOBOARD_SW23				(12)
#define IOBOARD_SW24				(13)
#define IOBOARD_SW25				(14)
#define IOBOARD_SW26				(15)

#define PCLKB						(60)	//PCLKB=60MHz

/*----------------------------------------------------------------------
	グローバル変数
----------------------------------------------------------------------*/
extern volatile int g_function_use[IOBOARD_CMT3_FUNCTION_NUM];
extern volatile int g_adc_flag;
extern volatile unsigned short g_adc_result;
extern volatile unsigned char g_led7seg_data[IOBOARD_LED7SEG_COM];
extern volatile unsigned char g_matrixsw[IOBOARD_MATRIXSW_NUM];
extern volatile unsigned short g_tpu2_tgra;
extern volatile unsigned short g_tpu2_tgrb;

/*----------------------------------------------------------------------
	関数プロトタイプ宣言
----------------------------------------------------------------------*/
extern int push_sw_init(void);
extern unsigned char push_sw_read(void);
extern int intr_push_sw_init(int timing);
extern int intr_push_sw_start(void);
extern int intr_push_sw_stop(void);
extern int led_init(void);
extern int led_set(unsigned char led);
extern int buzzer_freq_set(unsigned short freq);
extern int buzzer_on(void);
extern int buzzer_off(void);
extern int led8_cycle_set(unsigned short cycle);
extern int led8_duty_set(float duty);
extern int led8_on(void);
extern int led8_off(void);
extern int stepping_motor_init(void);
extern int stepping_motor_stop(void);
extern int stepping_motor_step_move(int direction);
extern int stepping_motor_drive(unsigned char pattern);
extern int adc_start(void);
extern int adc_stop(void);
extern unsigned short adc_val(void);
extern int led7seg_init(void);
extern int led7seg_start(void);
extern int led7seg_stop(void);
extern int led7seg_segument_data_set(unsigned char column, unsigned char seg, unsigned char seg_on_off);
extern int led7seg_disp_hex(unsigned short data);
extern int led7seg_disp_num(short data, unsigned char dp);
extern int matrixsw_init(void);
extern int matrixsw_start(void);
extern int matrixsw_stop(void);
extern int matrixsw_read(unsigned char key);

#endif