// lcd_1602.h
//
// header of SC1602 charactor LCD

/*
 * @file  lcd_1602.h
 * @brief LCDドライバヘッダ
 *
 * 本ソフトウェアの著作権は作成元である(株)北斗電子が所有するものとし、
 * (株)北斗電子は、以下の (1)-(3) の条件を満たす場合に限り、
 * 本ソフトウェア（本ソフトウェアを改変したものを含む。以下同じ）を
 * 使用・複製・改変・再配布（以下、利用と呼ぶ）することを無償で許諾する。
 *
 * (1) 本ソフトウェアをソースコードの形で利用する場合には、下記の著作
 *	   権表示、この利用条件が、そのままの形でソースコード中に含まれて
 *	   いること。
 * (2) 本ソフトウェアの一部または全てを無断で転載することを禁止するもの
 *	   とする。雑誌などへ紹介・収録の場合は(株)北斗電子に連絡願います。
 * (3) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損害
 *	   からも、(株)北斗電子は一切の責任を負わないものとする。
 *
 * Copyright (C) Hokuto denshi Co,Ltd. 2018
 */

#ifndef LCD_1602_H__
#define LCD_1602_H__

#define WAIT_20US		(300)

extern void lcd_init(void);
extern void lcd_cmd(unsigned char c);
extern void lcd_hs1(void);
extern void lcd_hs2(void);
extern void lcd_clear(void);
extern void lcd_write_char(unsigned char c);
extern void lcd_write_hex(unsigned char c);
extern void lcd_write_byte_int(unsigned char num);
extern void lcd_write_short_int(unsigned short num);
extern void lcd_write_str(unsigned char *str);
extern void lcd_cursor_move(unsigned char lines, unsigned char pos);

#endif